% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{GetCustomKmerCounts}
\alias{GetCustomKmerCounts}
\title{Generate custom k-mer abundance from a given reference genome}
\usage{
GetCustomKmerCounts(k, ref.genome, custom.ranges, filter.path, verbose = FALSE)
}
\arguments{
\item{k}{Length of k-mers (k>=2)}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{custom.ranges}{A keyed data table which has custom ranges information. It
has three columns: chrom, start and end. It should use one-based coordinate
system. You can use the internal function in this package
\code{ICAMS:::ReadBedRanges} to read a BED file in 0-based coordinates and
convert it to 1-based coordinates.}

\item{filter.path}{If given, homopolymers will be masked from
genome(sequence). Only simple repeat masking is accepted now.}

\item{verbose}{If \code{TRUE} generate progress messages.}
}
\value{
Matrix of the counts of custom k-mer across the \code{ref.genome}
}
\description{
Generate custom k-mer abundance from a given reference genome
}
\keyword{internal}
