% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{MutectVCFFilesToCatalogAndPlotToPdf}
\alias{MutectVCFFilesToCatalogAndPlotToPdf}
\title{Create SBS, DBS and Indel catalogs from Mutect VCF files and plot them to PDF}
\usage{
MutectVCFFilesToCatalogAndPlotToPdf(files, ref.genome,
  trans.ranges = NULL, region = "unknown", names.of.VCFs = NULL,
  tumor.col.names = NA, output.file = "")
}
\arguments{
\item{files}{Character vector of file paths to the Mutect VCF files.}

\item{ref.genome}{A \code{ref.genome} argument as described in
\code{\link{ICAMS}}.}

\item{trans.ranges}{a \code{\link[data.table]{data.table}} which contains
transcript range and strand information. Please refer to
\code{\link{TranscriptRanges}} for more details.}

\item{region}{A character string designating a genomic region;
see \code{\link{as.catalog}} and \code{\link{ICAMS}}.}

\item{names.of.VCFs}{Character vector of names of the VCF files. The order of
names in \code{names.of.VCFs} should match the order of VCF file paths in
\code{files}. If \code{NULL}(default), this function will remove all of the
path up to and including the last path separator (if any) in \code{files}
and file paths without extensions (and the leading dot) will be used as the
names of the VCF files.}

\item{tumor.col.names}{Character vector of column names in VCFs which contain
the tumor sample information. The order of names in \code{tumor.col.names}
should match the order of VCFs specified in \code{files}. If
\code{tumor.col.names} is equal to \code{NA}(default), this function will
use the 10th column in all the VCFs to calculate VAFs.
See \code{\link{GetMutectVAF}} for more details.}

\item{output.file}{The base name of the PDF files to be produced; multiple
files will be generated, each ending in \eqn{x}\code{.pdf}, where \eqn{x}
indicates the type of catalog plotted in the file.}
}
\value{
A list of 3 SBS catalogs (one each for 96, 192, and 1536), 3 DBS
  catalogs (one each for 78, 136, and 144), Indel catalog and their graphs
  plotted to PDF with specified file name. If trans.ranges = NULL, SBS 192
  and DBS 144 catalog will not be generated and plotted. Each catalog has
  attributes added. See \code{\link{as.catalog}} for more details.
}
\description{
Create 3 SBS catalogs (96, 192, 1536), 3 DBS catalogs (78, 136, 144) and
Indel catalog from the Mutect VCFs specified by \code{files} and plot them to
PDF
}
\details{
This function calls \code{\link{MutectVCFFilesToCatalog}} and
\code{\link{PlotCatalogToPdf}}
}
\note{
SBS 192 and DBS 144 catalogs include only mutations in transcribed
  regions. In ID (small insertion and deletion) catalogs, deletion repeat sizes
  range from 0 to 5+, but for plotting and end-user documentation deletion
  repeat sizes range from 1 to 6+.
}
\section{Comments}{

To add or change attributes of the catalog, you can use function \code{\link[base]{attr}}. \cr
For example, \code{attr(catalog, "abundance") <- custom.abundance}.
}

\examples{
file <- c(system.file("extdata",
                      "Mutect.GRCh37.vcf",
                      package = "ICAMS"))
if (requireNamespace("BSgenome.Hsapiens.1000genomes.hs37d5", quietly = TRUE)) {
  catalogs <- 
    MutectVCFFilesToCatalogAndPlotToPdf(file, ref.genome = "hg19", 
                                        trans.ranges = trans.ranges.GRCh37,
                                        region = "genome",
                                        output.file = 
                                        file.path(tempdir(), "Mutect"))}
}
