% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibrv2_bdi.R
\name{ibrv2_bdi}
\alias{ibrv2_bdi}
\title{Standardized values for IBRv2 (Integrated Biological Responses version 2)}
\usage{
ibrv2_bdi(df)
}
\arguments{
\item{df}{A data frame containing values the enzymes activities with a reference value on the first rows.}
}
\value{
Returns a dataframe with standardized IBRv2 values for each biomarker in comparison to reference treatment
}
\description{
This function calculates de standardized values for IBRv2 index proposed by Sanchez et al. 2013.
}
\details{
Gives a dataframe with the standardized values for each area/treatment in your input data to be used to create the radarchart with the function ibrv2_chart from this same package.
}
\section{Warnings}{


You must have at least 3 biomarkers and a maximum of 15 biomarkers to perform this index correctly.

If you have more than one independent variable, it is necessary to separate the data.frame in subsets so there's only one reference value for each level.
}

\section{References}{


Sanchez, W., Burgeot, T., & Porcher, J.-M. (2013). A novel “Integrated Biomarker Response” calculation based on reference deviation concept. Environmental Science and Pollution Research, 20(5), 2721–2725. https://doi.org/10.1007/s11356-012-1359-1
}

\examples{
data(enzact2)

ibrv2_bdi(enzact2)

}
