% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hydro3Stats.R
\name{Hydro3_Estimation}
\alias{Hydro3_Estimation}
\title{Hydro3 estimation}
\usage{
Hydro3_Estimation(
  y,
  dist,
  Emeth = Emeth_def,
  Umeth = Umeth_def,
  options = options_def,
  mcmcoptions = mcmcoptions_def,
  prior = GetDefaultPrior(GetParNumber(dist)),
  do.KS = TRUE,
  do.MK = TRUE,
  do.Pettitt = TRUE
)
}
\arguments{
\item{y}{numeric vector, data.}

\item{dist}{character, distribution name. See dataset distInfo for a description of available distributions.
In particular, type names(distInfo) for the list of available distributions, and 
distInfo[['GEV']] for more information on a particular distribution (here, GEV).}

\item{Emeth}{character, estimation method. Default is 'LMOM' (L-Moments), available: 
'MOM' (Moments), 'ML' (Maximum Likelihood), 'BAY' (Bayesian).}

\item{Umeth}{character, uncertainty quantification method. Default is 'PBOOT' (Parametric bootstrap), available: 
'BOOT' (Bootstrap, not recommended), 'NONE', 'ML' (only usable when Emeth='ML' as well), 
and 'BAY' (the only usable method when Emeth='BAY').}

\item{options}{list, options, see details below.}

\item{mcmcoptions}{list, MCMC options, see details below.}

\item{prior}{list, prior distributions, only used when Emeth='BAY'. See ?GetEstimate_BAY for details.}

\item{do.KS, do.MK, do.Pettitt}{logical, perform KS/MK/Pettitt tests?}
}
\value{
A list with the following components:
    \item{dist}{character, estimated distribution.}
    \item{ok}{logical, did estimation succeed?}
    \item{err}{integer, error code (0 if ok).}
    \item{message}{error message.}
    \item{empirical}{data frame, sorted data and empirical estimates 
        (nonexceedance frequency, return period and reduced variate) }
    \item{pcdf}{data frame, estimated pdf and cdf}
    \item{quantile}{data frame, estimated quantiles and uncertainty intervals}
    \item{par}{data frame, estimated parameters and uncertainty intervals}
    \item{KS}{list, result of the Kolmogorov-Smirnov test, see ?KS}
    \item{MK}{list, result of the Mann-Kendall test, see ?MK}
    \item{Pettitt}{list, result of the Pettitt test, see ?Pettitt}
    \item{u}{list, parameter uncertainty in the form of a covariance matrix ($cov)
        and simulated parameter replicates ($sim). Also contains error-handling flags 
        $ok, $err and $message.}
}
\description{
Main estimation function used in the HydroPortail.
In short, this function estimates a distribution and the associated uncertainty, 
and returns all needed information to display and plot the results 
(parameter estimates, quantile curves, etc.)
}
\details{
The argument 'options' allows controlling various properties of the analysis and results.
    It is a list with the following components:
    \itemize{
    \item{FreqFormula, character, formula for computing nonexceedance frequency, see ?GetEmpFreq.}
    \item{pgrid, numeric vector, probabilities defining the x values where pdf f(x) and cdf F(x) 
        are computed. These x values are quantiles from the estimated distribution 
        with probabilities pgrid.}
    \item{Tgrid, numeric vector, return periods where quantile function q(T) is computed.}
    \item{IClevel, numeric, level of uncertainty interval.}
    \item{p2T, numeric, conversion factor between nonexceedance probability p and return period T.
        p=1-1/(p2T*T). In general p2T=1 but for a peak-over-threshold approach leading to say 3 events
        per year on average, p2T=3.}
    \item{invertT, logical, when invertT=TRUE, LARGE return periods correspond to SMALL data values.
        This is typically used for low-flow statistics.}
    \item{splitZeros, logical, when splitZeros=TRUE zero and negative values are removed from the data y before 
        estimating the distribution,and are used to estimate the probability of zeros p0. This is 
        typically used for low-flow statistics to estimate the probability of zero streamflow.}
    \item{lang, chanracter, language ('fr' or 'en').}
    \item{nsim, integer, number of replicated parameters representing uncertainty.}
    }
    The argument 'mcmcoptions' is only used when Emeth='BAY' and is a list controlling MCMC properties: 
    \itemize{
    \item{mult, numeric, see ?Metropolis_OAAT_adaptive}
    \item{eps, numeric, see ?Metropolis_OAAT_adaptive}
    \item{batch.length, integer, see ?Metropolis_OAAT_adaptive}
    \item{batch.n, integer, see ?Metropolis_OAAT_adaptive}
    \item{moverate.min, numeric, see ?Metropolis_OAAT_adaptive}
    \item{moverate.max, numeric, see ?Metropolis_OAAT_adaptive}
    \item{mult.down, numeric, see ?Metropolis_OAAT_adaptive}
    \item{mult.up, numeric, see ?Metropolis_OAAT_adaptive}
    \item{burn, numeric, burn-in factor, e.g. if burn=0.2 the first 20 percents of MCMC samples are discarded}
    \item{slim, integer, sliming factor, e.g. if slim=5 only one MCMC sample every 5 is kept (after burn-in)}
    }
}
\examples{
y=stats::rnorm(50)
H3=Hydro3_Estimation(y,'Normal')
H3=Hydro3_Estimation(y,'GEV',Emeth='ML',Umeth='ML')
}
