% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-plsmo.r
\name{stat_plsmo}
\alias{stat_plsmo}
\title{Add a lowess smoother without counfidence bands.}
\usage{
stat_plsmo(
  mapping = NULL,
  data = NULL,
  geom = "smooth",
  position = "identity",
  n = 80,
  fullrange = FALSE,
  span = 2/3,
  fun = function(x) x,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping, data, geom, position, show.legend, inherit.aes}{see ggplot2 documentation}

\item{n}{number of points to evaluate smoother at}

\item{fullrange}{should the fit span the full range of the plot, or just
the data}

\item{span}{see \code{f} argument to \code{lowess}}

\item{fun}{a function to transform smoothed \code{y}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{...}{other arguments are passed to smoothing function}
}
\value{
a data.frame with additional columns
  \item{y}{predicted value}
}
\description{
Automatically selects \code{iter=0} for \code{lowess} if \code{y} is binary, otherwise uses \code{iter=3}.
}
\examples{
\donttest{
c <- ggplot(mtcars, aes(qsec, wt))
c + stat_plsmo()
c + stat_plsmo() + geom_point()

c + stat_plsmo(span = 0.1) + geom_point()

# Smoothers for subsets
c <- ggplot(mtcars, aes(y=wt, x=mpg)) + facet_grid(. ~ cyl)
c + stat_plsmo() + geom_point()
c + stat_plsmo(fullrange = TRUE) + geom_point()

# Geoms and stats are automatically split by aesthetics that are factors
c <- ggplot(mtcars, aes(y=wt, x=mpg, colour=factor(cyl)))
c + stat_plsmo() + geom_point()
c + stat_plsmo(aes(fill = factor(cyl))) + geom_point()
c + stat_plsmo(fullrange=TRUE) + geom_point()

# Example with logistic regression
data("kyphosis", package="rpart")
qplot(Age, as.numeric(Kyphosis) - 1, data = kyphosis) + stat_plsmo()
}
}
\seealso{
\code{\link{lowess}} for \code{loess} smoother.
}
