% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeconvoluteSpectrum.R
\name{DeconvoluteSpectrum}
\alias{DeconvoluteSpectrum}
\title{DeconvoluteSpectrum.}
\usage{
DeconvoluteSpectrum(dat = NULL, rt = NULL, rt_dev = 3, mz1 = NULL,
  mz_dev = 0.003, use.mz.adjust = FALSE, ionization = c("APCI",
  "ESI")[1], smooth = 0)
}
\arguments{
\item{dat}{A list of xcmsRaws or an xcmsSet object.}

\item{rt}{Retention time to search for maxima.}

\item{rt_dev}{Allowed retention time window.}

\item{mz1}{If specified, ensure that this mass is included in the spectrum (assumed base peak). NULL otherwise.}

\item{mz_dev}{Allowed mz deviation [Da].}

\item{use.mz.adjust}{Will adjust mz on an experiment wide basis.}

\item{ionization}{Either APCI or ESI. Choice will modify some internal parameters and checks performed.}

\item{smooth}{Smoothing parameter passed on to \link{getMultipleBPC}.}
}
\value{
A pseudo spectrum at rt (containing mz1 if specified). Effectively a 2-column matrix (mz, int) with rt as attribute
}
\description{
\code{DeconvoluteSpectrum} will evaluate a list of xcmsRaw objects at a given time (rt) and potential mass (mz1).
The main purpose is to deconvolute the mass spectrum at rt including mz1.
}
\details{
Will test all mz at spectrum of base peak within range for co-apex, rt diff and ratio consistency/correlation over a set of samples.
}
\examples{
# Please use examples from previous versions as xcms (and xcms objects)
# are no longer supported during CRAN checks leading to package rejection
# if included (and I do not know a work around). :(

}
