% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_control.R
\name{quality_control}
\alias{quality_control}
\title{quality_control}
\usage{
quality_control(dat, state_first, state_second, chosen_time, in_time,
  relative = TRUE)
}
\arguments{
\item{dat}{file supplied by user using read_hdx()}

\item{state_first}{first state}

\item{state_second}{second state}

\item{chosen_time}{chosen time}

\item{in_time}{in time}

\item{relative}{\code{logical}, determines if values are relative or absolute.}
}
\value{
data.frame with values - time, value, uncertainty
}
\description{
Checks uncertainty level (mean for all peptides in sequence) depending on chosen out value.
Visualization for results is provided in examples.
}
\examples{
dat <- read_hdx(system.file(package = "HaDeX", "HaDeX/data/KD_180110_CD160_HVEM.csv"))
(result <- quality_control(dat = dat,
                           state_first = "CD160",
                           state_second = "CD160_HVEM", 
                           chosen_time = 1, 
                           in_time = 0.001, 
                           relative = TRUE))    

}
