\name{HHscriptnames}
\alias{HHscriptnames}
\alias{WindowsPath}

\title{Find absolute pathname of a script file for the HH book in the HH
  package.}
\description{Find absolute pathname of a script file for the HH book in the HH
  package.}

\usage{
HHscriptnames(chapternumbers, edition=2)

WindowsPath(x)
}
\arguments{
  \item{chapternumbers}{A number or letter name for a chapter in the HH
    book.  For the Second edition, the valid values are from the set
    \code{c(1:20, LETTERS[1:12])}.
    For the First edition, the valid values are from the set
    \code{c(1:18)}.
    The argument may be a vector of one or more items.
  The file basename for the corresponding chapter is also accepted.}
  \item{edition}{Either 2 or 1, for the second or first edition of the
    book \emph{Statistical Analysis and Data Display}.}
  \item{x}{A vector or matrix of pathnames as generated by \R, with \code{"/"} as the
    separator character.}
}
\value{For \code{HHscriptnames}, matrix of full pathnames to script files in the HH
  package.

For \code{WindowsPath}, a vector or matrix of full pathnames with all \code{"/"} characters
changed to \code{"\\\\"}.
}
\author{ Richard M. Heiberger <rmh@temple.edu> }
\references{
  Heiberger, Richard M. and Holland, Burt (anticipated 2015).
\emph{Statistical Analysis and Data Display: An Intermediate Course
  with Examples in R}, Second Edition.
 Springer Texts in Statistics. Springer.
 ISBN x-xxx-xxxxx-x.
  Heiberger, Richard M. and Holland, Burt (2004).
\emph{Statistical Analysis and Data Display: An Intermediate Course
  with Examples in S-Plus, R, and SAS}, First Edition.
 Springer Texts in Statistics. Springer.
 ISBN 0-387-40270-5.
}
\examples{
\dontrun{
  ## All Operating Systems

  ## Second Edition
  HHscriptnames(6)
  HHscriptnames("6")
  HHscriptnames("oway")

  HHscriptnames("H")
  HHscriptnames("RApx")

  HHscriptnames(c(1:20, LETTERS[1:12]))

  ## with Windows pathname separators
  WindowsPath(HHscriptnames(c(6:14)))
  cat(WindowsPath(HHscriptnames(6)), "\n")
  cat(paste(WindowsPath(HHscriptnames(c(6:14))), "\n"))

  ## First Edition
  HHscriptnames(6, edition=1)
}
}
\keyword{misc}
