% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_volcano.R
\name{plots_vol_tp}
\alias{plots_vol_tp}
\title{Returns volcano plots for timepoints in the data frame}
\usage{
plots_vol_tp(df, replicates = 3, pv_cutoff = 0.01, cola)
}
\arguments{
\item{df}{output from functions output_tp}

\item{replicates}{number of replicates in set as default set to 3.}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{cola}{color pallette for different Protein States. As default Paired pallette from color.Brewer is used.}
}
\value{
volcano plots
}
\description{
Returns volcano plots for each peptide. Critical interval is calculated according to #' Reliable Identification of Significant Differences in Differential Hydrogen Exchange-Mass Spectrometry Measurements Using a Hybrid Significance Testing Approach
Tyler S. Hageman and David D. Weis
Analytical Chemistry 2019 91 (13), 8008-8016 DOI: 10.1021/acs.analchem.9b01325
calculations for alpha 0.99
pvalues calculated using Welch t-test.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
plots_vol_tp(df=a, replicates=3, cola=c(1:4), pv_cutoff=0.01 )
plots_vol_tp(df=a, pv_cutoff=0.05)
}
