% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HDSpatialScan_plotSummary.R
\name{plotSummary.ResScanOutputMulti}
\alias{plotSummary.ResScanOutputMulti}
\title{Plots the mean or median spider chart of the clusters detected by a multivariate scan function (MG or MNP)}
\usage{
\method{plotSummary}{ResScanOutputMulti}(x, type = "mean", colors = "red", only.MLC = FALSE, ...)
}
\arguments{
\item{x}{ResScanOutputMulti. Output of a multivariate scan function (MG or MNP).}

\item{type}{character. "mean" or "median". If "mean": the means in the clusters are plotted in solid lines, outside the cluster in dots, the global mean is in black. If "median": the medians in the clusters are plotted in solid lines, outside the cluster in dots, the global median is in black.}

\item{colors}{character. The colors to plot the clusters' summaries. If length(colors)==1 then all the clusters will be plotted in this color. Else there must be the same number of elements in colors than the number of clusters}

\item{only.MLC}{logical. Should we plot only the MLC or all the significant clusters?}

\item{...}{Further arguments to be passed to or from methods.}
}
\value{
No value returned, plots the spider chart.
}
\description{
This function plots the mean or median spider chart of the clusters detected by a multivariate scan function (MG or MNP).
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("multi_data")
coords <- coordinates(map_sites)

res_mnp <- SpatialScan(method = "MNP", data=multi_data, sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2,
variable_names = c("NO2", "O3", "PM10", "PM2.5"))$MNP

plotSummary(x = res_mnp, type = "mean")}
\dontshow{
library(sp)
data("map_sites")
data("multi_data")
indices <- c(51:75)
coords <- coordinates(map_sites[indices,])
res_mnp <- SpatialScan(method = "MNP", data=multi_data[indices,],
sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)$MNP
if(length(res_mnp$sites_clusters)>0){
plotSummary(x = res_mnp, type = "mean")
}
}

}
