% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{clusters}
\alias{clusters}
\title{Creation of the matrix of potential clusters}
\usage{
clusters(sites_coord, system, mini, maxi, type_minimaxi, sites_areas)
}
\arguments{
\item{sites_coord}{numeric matrix. Matrix of the coordinates of the sites (or the individuals, in that case there can be many individuals with the same coordinates). It has the same number of rows as the number of sites or individuals and 2 columns.}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{mini}{numeric. Minimum for the clusters (see type_minimaxi).}

\item{maxi}{numeric. Maximum for the clusters (see type_minimaxi).}

\item{type_minimaxi}{character. Type of minimum and maximum: "area": the minimum and maximum area of the clusters, "radius": the minimum and maximum radius, or "sites/indiv": the minimum and maximum number of sites or individuals in the clusters.}

\item{sites_areas}{numeric vector. Areas of the sites. It must contain the same number of elements than the rows of sites_coord. If the data is on individuals and not on sites, there can be duplicated values. By default: NULL}
}
\value{
The list of the following elements:
\itemize{
\item matrix_clusters: numeric matrix of 0 and 1
\item centres: the coordinates of the centres of each cluster (numeric matrix)
\item radius: the radius of the clusters in km if system = "WGS84" or in the coordinates unit otherwise (numeric vector)
\item areas: the areas of the clusters (in same units as in sites_areas). Provided only if sites_areas is not NULL. Numeric vector
\item system: the system of coordinates (character)
}
}
\description{
This function creates the matrix in which each column corresponds to a potential clusters, taking the value 1 when a site (or an individual) is in the potential cluster and 0 otherwise.
}
