% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCV.R
\name{plotMap}
\alias{plotMap}
\title{Drawing a Thematic Map with a Quantitative Feature}
\usage{
plotMap(
  map,
  feat,
  color = topo.colors(10),
  main = "",
  bar_title = "rank",
  zlim = NULL
)
}
\arguments{
\item{map}{\code{SpatialPolygonsDataFrame} object consisting of data and polygons.}

\item{feat}{numberic vector having the same elements as the number of polygons in the input \code{map}.}

\item{color}{vector of distinct colors for converting values of \code{feat}.}

\item{main}{character specifying the main title.}

\item{bar_title}{character specifying the text over the color bar.}

\item{zlim}{length-2 numeric vector specifying the range of values to be converted.}
}
\value{
A colored map.
}
\description{
Plot the polygons in a \code{SpatialPolygonsDataFrame} object, and turn the values of a quantitative feature into colors over individual polygons.
}
\examples{
require(sp)
grd  <-  GridTopology(c(1,1),  c(1,1),  c(5,5))
polys  <-  as(grd,  "SpatialPolygons") 
centroids  <-  coordinates(polys)
gdomain  <-  SpatialPolygonsDataFrame(polys,  data=data.frame(x=centroids[,1],  
  y=centroids[,2], row.names=row.names(polys)))
feat <- gdomain$x*5+gdomain$y^2
plotMap(gdomain,feat)

}
\seealso{
\code{\link{SpatialPolygonsDataFrame}}
}
