package de.fhg.iais.kd.gridr.interfaces;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;



public class FTPDownload {

	/**
	 * @param args
	 * args[0] url of the file to download
	 * args[1] path where to download that file, must not exist
	 */
	public static void main(String[] args) {
		if(args.length<2){
			System.err.println("wrong input arguments, usage: url, file");
			return;
		}
		URL url=null;
		try {
			url = new URL(args[0]);
		} catch (MalformedURLException e1) {
			System.err.println("Path dont exists");
		}
		File localFile= new File(args[1]);
		
		
		if(localFile.exists()){
			System.err.println("local file exists, stopping download");
			return;
		}

		URLConnection urlc;
		try{
			urlc = url.openConnection();
			InputStream is = urlc.getInputStream();
	
			FileOutputStream os = new FileOutputStream(localFile);
			byte[] buf = new byte[16384];
			int c;
			while (true) {
				c = is.read(buf);
				if (c <= 0)
					break;
				os.write(buf, 0, c);
			}
			os.close();
			is.close();
			urlc = null;
		}
		catch(Exception e){
			System.err.println("cannot download file: ");
			e.printStackTrace();
		}
	}

}
