% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezierArrowGradient.R
\name{bezierArrowGradient}
\alias{bezierArrowGradient}
\title{A bezier arrow with gradient}
\usage{
bezierArrowGradient(x = c(0.2, 0.7, 0.3, 0.9), y = c(0.2, 0.2, 0.9, 0.9),
  width = 0.05, clr = "#000000", default.units = "npc",
  align_2_axis = TRUE, grdt_type = c("triangle", "rectangle"),
  grdt_prop = 0.8, grdt_decrease_prop = 0.5, grdt_clr_prop = 0.7,
  grdt_line_width, grdt_clr = "#2F4F2F", vp = NULL, gp = gpar(),
  rm_intersect = 3L, ...)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of
    spline control points.}

\item{y}{A numeric vector or unit object specifying y-locations of
    spline control points.}

\item{width}{The width of the arrow, either a numeric single number or a unit. \strong{Note:}
The arrow does not rely on \code{lwd} but on actual width.}

\item{clr}{The color of the arrow. This is the main color of the arrow and not the gradient color.}

\item{default.units}{A string indicating the default units to use
    if \code{x} or \code{y}
    are only given as numeric vectors.}

\item{align_2_axis}{Indicates if the arrow should be vertically/horizontally
aligned. This is useful for instance if the arrow attaches to a box.}

\item{grdt_type}{The type of growth and gradient that is to be used,
currently it only supports triangle (I'm considering adding bezier curves
but currently I'm a little tired of coding)}

\item{grdt_prop}{The proportion of the full length that should be a the gradient. The gradient
consists of three things:
(1) the central band,
(2) the slimming of the central band,
(3) the color shift into the arrow color.
\emph{Note} that the the slimming and color proportions can be overlapping.}

\item{grdt_decrease_prop}{The proportion of the gradient that should be decreasing,
i.e. narrowing according to the \code{grdt_type} argument.}

\item{grdt_clr_prop}{The proportion of the gradient that should be converging to the arrow color.}

\item{grdt_line_width}{The width of the border line. If not specified it defaults to 5 \% of
the original width, note the gradient's width is thus 90 \%.}

\item{grdt_clr}{The color of the gradient.}

\item{vp}{A Grid viewport object (or NULL).}

\item{gp}{An object of class \code{gpar}, typically the output
    from a call to the function \code{gpar}.  This is basically
    a list of graphical parameter settings.}

\item{rm_intersect}{Set to 0 if you want to skip intersection removal, 1 only to remove left or
 2 to only remove right. See details for why.

 @section Remove intersections:

 When the line is wide and the arrow has a narrow curve there may appear an empty triangle due
 to polygon cancellation (two polygons within the same are cancel out). This behaviour may be
 ugly and the function therefor tries to remove these.

 \emph{Note:} it is expensive to check if there are the lineas may intersect at one point,
 remove those unexpected, and then adjust the line to the new situation so that the
 top and bottom lines match. It can also cause some unexpected behaviour why you may want to
 remove this feature if the arrow behaves erratically.}

\item{...}{Passed on to \code{\link{bezierArrowSmpl}}}
}
\value{
\code{grid::gList()} A grob of \code{\link[grid]{gList}}-type
}
\description{
This is an experimental addition to the original \code{\link{bezierArrowSmpl}}
with the addition of a gradient in the center of the arrow that fades.
}
\section{Note}{

The triangle section of the arrow is not currently included in the gradient.
}

\examples{
library(grid)
grid.newpage()
arrowGrob <- bezierArrowGradient(x = c(.1,.3,.6,.9),
                                     y = c(0.2, 0.2, 0.9, 0.9))
grid.draw(arrowGrob)
}
