% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_BA_plot.R
\name{robustBAplot}
\alias{robustBAplot}
\title{R function to plot a robust version of the Bland-Altman plot}
\usage{
robustBAplot(a, b, z = 1.96, methAlab = "Method A",
  methBlab = "Method B", cex = 0.6)
}
\arguments{
\item{a}{Vector storing the first set of measurements to be compared.}

\item{b}{Vector storing the second set of measurements to be compared.}

\item{z}{Value for the confidence interval for the median difference; set by default to 1.96
(corresponding to 95 percent CI).}

\item{methAlab}{Label to be used in the returned chart to refer to the method yielding the
first set of measurements.}

\item{methBlab}{Label to be used in the returned chart to refer to the method yielding the
second set of measurements.}

\item{cex}{Size of the data points.}
}
\description{
The function allows to plot a robust version of the Bland-Altman plot.\cr
}
\details{
The function returns a chart based on robust (i.e. resistant to outlying values) measures of
central tendency and variability: median and Median Absolute Deviation (MAD) (Wilcox R R. 2001.
"Fundamentals of modern statistical methods: Substantially improving power and accuracy". New
York: Springer) instead of mean and standard deviation.\cr

The x-axis displays the median of the
two variables being compared, while the y-axis represents their difference. A solid horizontal
line represents the bias, i.e. the median of the differences reported on the y-axis. Two dashed
horizontal lines represent the region in which 95percent of the observations are expected to lie;
they are set at the median plus or minus z*(MAD/0.6745).
}
\examples{
#create a first toy vector
a <- rnorm(30,10,1)

#create a second toy vector
b <- a*runif(30,1,1.5)

robustBAplot(a,b)

}
\keyword{robustBAplot}
