% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_t_test.r
\name{perm.t.test}
\alias{perm.t.test}
\title{R function for permutation-based t-test}
\usage{
perm.t.test(data, format, B = 999)
}
\arguments{
\item{data}{Dataframe containing the data.}

\item{format}{It takes "long" if the data are arranged in two columns, with the left-hand one
containing the values, and the righ-hand one containing a grouping variable; it takes "short"
if the values of the two groups being compared are stored in two different adjacent columns.}

\item{B}{Desired number of permutations (set at 999 by default).}
}
\value{
The chart returned by the function displays the distribution of the permuted mean
difference between the two samples; a dashed line indicates the observed mean difference.
A rug plot at the bottom of the density curve indicates the individual permuted mean differences.
At the bottom of the chart, a number of information are displayed. In particular,
the observed mean difference, the number of
permutations used, and the permuted p-value are reported. In the last row, the result of the
regular t-test (both assuming and not assuming equal variances) is reported to allow users to
compare the outcome of these different versions of the test.
}
\description{
The function allows to perform a permutation-based t-test to compare two independent groups. The
test's results are graphically displayed within the returned chart.
}
\details{
A permutation t-test proves useful when the assumption of 'regular' t-test are not met. In
particular, when the two groups being compared show a very skewed distribution, and when the
sample sizes are very unbalanced.\cr

"The permutation test is useful even if we plan to use the two-sample t test. Rather than relying
on Normal quantile plots of the two samples and the central limit theorem, we can directly check
the Normality of the sampling distribution by looking at the permutation distribution.
Permutation tests provide a “gold standard” for assessing two-sample t tests. If the two P-values
differ considerably, it usually indicates that the conditions for the two-sample t don’t hold for
these data. Because permutation tests give accurate P-values even when the sampling distribution
is skewed, they are often used when accuracy is very important." (Moore, McCabe, Craig,
"Introduction to the Practice of Statistics", New York: W. H. Freeman and Company, 2009).\cr
}
\examples{
#load the 'resample' package which stores a toy dataset
library(resample)

#load the 'Verizon' dataset
data("Verizon")

#performs the permutation-based t-test using 199 permutations
perm.t.test(Verizon, format="long", B=199)

}
\keyword{perm.t.test}
