% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_repos.R
\name{get_repos_with_R_packages}
\alias{get_repos_with_R_packages}
\title{Get data on package usage across repositories}
\usage{
get_repos_with_R_packages(
  gitstats,
  packages,
  only_loading = FALSE,
  split_output = FALSE,
  cache = TRUE,
  verbose = is_verbose(gitstats)
)
}
\arguments{
\item{gitstats}{A GitStats object.}

\item{packages}{A character vector, names of R packages to look for.}

\item{only_loading}{A boolean, if \code{TRUE} function will check only if package
is loaded in repositories, not used as dependencies.}

\item{split_output}{Optional, a boolean. If \code{TRUE} will return a list of
tables, where every element of the list stands for the package passed to
\code{packages} parameter. If \code{FALSE}, will return only one table with name of
the package stored in first column.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}
}
\value{
A \code{tibble} or \code{list} of \code{tibbles} depending on \code{split_output}
parameter.
}
\description{
Wrapper over searching repositories by code blobs related to
loading package (\code{library(package)} and \code{require(package)} in all files) or
using it as a dependency (\code{package} in \code{DESCRIPTION} and \code{NAMESPACE}
files).
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs", "openpharma")
  )

 get_repos_with_R_packages(
   gitstats = my_gitstats,
   packages = c("purrr", "shiny"),
   split_output = TRUE
 )
}
}
