% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SGAT.R
\name{twilight}
\alias{twilight}
\title{Times of Sunrise and Sunset}
\usage{
twilight(tm, lon, lat, rise, zenith = 96, iters = 3)
}
\arguments{
\item{tm}{vector of approximate times of twilight.}

\item{lon}{vector of longitudes.}

\item{lat}{vector of latitudes.}

\item{rise}{logical vector indicating whether to compute rise or set.}

\item{zenith}{the solar zenith angle that defines twilight.}

\item{iters}{number of iteratve refinements made to the initial
approximation.}
}
\value{
a vector of twilight times.
}
\description{
Estimate time of sunrsie or sunset for a given day and location
}
\details{
\code{twilight} uses an iterative algorithm to estimate times of
sunrise and sunset.

Note that these functions return the twilight that occurs on the
same date GMT as \code{tm}, and so sunset may occur before
sunrise, depending upon latitude.

Solar declination and equation of time vary slowly over the day,
and so the values of the Solar declination and equation of time at
sunrise/sunset are well approximated by their values at 6AM/6PM
local time. The sun's hour angle and hence sunrise/sunset for the
required zenith can then be caclulates from these approximations.
The calculation is then repeated using the approximate
sunrise/sunset times to derive more accurate values of the Solar
declination and equation of time and hence better approximations
of sunrise/sunset.  The process is repreated and is accurate to
less than 2 seconds within 2 or 3 iterations.

\code{sunrise} and \code{sunset} are simple wrappers for \code{twilight}.
}

