## ---- include = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- setup-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(GeoFIS)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(conductivity_2014)
zoning <- NewZoning(conductivity_2014)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zonable_data <- zoning$zonable_data()

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$border <- NULL

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data(conductivity_border)
zoning$border <- conductivity_border

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$perform_voronoi()
vm <- zoning$voronoi_map()
par(mar = c(0, 0, 0, 0))
plot(vm)
plot(zoning$zonable_data(), add = TRUE)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$neighborhood <- NULL

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$neighborhood <- 5

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$perform_neighborhood()
nm <- zoning$neighborhood_map()
par(mar = c(0, 0, 0, 0))
plot(vm)
plot(subset(nm, filtered == FALSE), add = TRUE, col = "green")
plot(subset(nm, filtered == TRUE), add = TRUE, col = "red")

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$attribute_distance <- FuzzyDistance(NewFisIn(c(20, 30, 100), 12, 116))

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$attribute_distance <- EuclideanDistance()

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$zone_distance <- MaximumDistance()

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$combine_distance <- EuclideanDistance()

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$smallest_zone <- ZoneSize(1)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
zoning$perform_zoning()

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
map5 <- zoning$map(5)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
print(map5@data)

## ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(RColorBrewer)

palette <- brewer.pal(3, "Blues")
breaks <- c(30, 50, 70, 100)
colors <- palette[findInterval(map5$conduct_mean, vec = breaks)]
par(mar = c(0, 0, 2, 0))
plot(map5, col = colors, main = "Map 5 zones")
legend("bottomright", legend = levels(cut(map5$conduct_mean, breaks)), 
  fill = palette, title = "Conductivity mean")

## ---- message=FALSE, warning=FALSE------------------------------------------------------------------------------------------------------------------------------------------------
library(rgdal)

writeOGR(map5, dsn = ".", layer = "map5", driver = "ESRI Shapefile")

## ---- include=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------
file.remove(dir(path = ".", pattern = "map5.*"))

