% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/introns.R
\name{find_cryptic_splice_sites}
\alias{find_cryptic_splice_sites}
\title{Identify Potential Cryptic Splice Sites.}
\usage{
find_cryptic_splice_sites(input, genome, canonical_donor, canonical_acceptor, verbose)
}
\arguments{
\item{input}{A data frame containing intron coordinates, ideally generated
by \code{extract_introns()} and \code{assign_splice_sites()}. Must contain columns: \code{seqnames}, \code{intron_start},
\code{intron_end}, \code{strand}, \code{transcript_id}, \code{intron_number}, \code{gene_name},
\code{gene_id}, \code{donor_ss} and \code{acceptor_ss}.}

\item{genome}{A BSgenome object representing the genome sequence.
This is used to extract the sequence for each intron to identify splice sites.}

\item{canonical_donor}{A character vector of canonical donor splice site motifs.
Default is \code{c("GT")}.}

\item{canonical_acceptor}{A character vector of canonical acceptor splice site motifs.
Default is \code{c("AG")}.}

\item{verbose}{Logical; if \code{TRUE}, progress messages are printed. Default is \code{TRUE}.}
}
\value{
The input data frame with two logical columns:
\itemize{
\item \code{cryptic_donor}: \code{TRUE} if donor site is non-canonical.
\item \code{cryptic_acceptor}: \code{TRUE} if acceptor site is non-canonical.
}
}
\description{
This function identifies potential cryptic splice sites by comparing sequence motifs in introns to canonical splice site motifs (donor and acceptor). Cryptic splice sites are those that do not match the canonical donor (GT) or acceptor motifs (AG). It compares the identified splice sites with the provided canonical motifs and flags the sites that differ from the canonical patterns, making it useful for studying aberrant splicing events.
}
\details{
This function performs the following steps:
\itemize{
\item It assigns donor and acceptor splice sites to each intron using the \code{assign_splice_sites} function.
\item It compares the identified donor and acceptor splice sites against the provided canonical motifs (\code{GT} for donor and \code{AG} for acceptor by default). If the splice site sequences do not match the canonical motifs, they are flagged as cryptic.
\item The function returns a data frame with the same intron information, including additional columns \code{cryptic_donor} and \code{cryptic_acceptor} indicating whether the splice sites are cryptic.
\item The progress of the function is printed if the \code{verbose} argument is set to \code{TRUE}, showing also the total number of cryptic donor and acceptor sites and their respective percentages.
}
}
\examples{
suppressPackageStartupMessages(library(BSgenome.Hsapiens.UCSC.hg38))
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
introns_df <- extract_introns(gtf_v1)
introns_ss <- assign_splice_sites(introns_df, genome = BSgenome.Hsapiens.UCSC.hg38)
cryptic_sites <- find_cryptic_splice_sites(introns_ss, BSgenome.Hsapiens.UCSC.hg38)
head(cryptic_sites)

}
\seealso{
\code{\link{assign_splice_sites}}, \code{\link{extract_ss_motif}}
}
