% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searcher_efficiency_functions.R
\name{rpk}
\alias{rpk}
\title{Simulate parameters from a fitted pk model}
\usage{
rpk(n, model)
}
\arguments{
\item{n}{the number of simulation draws}

\item{model}{A \code{\link{pkm}} object (which is returned from 
\code{pkm()})}
}
\value{
list of pairs of matrices of \code{n} simulated \code{p} and
 \code{k} for cells defined by the \code{model} object.
}
\description{
Simulate parameters from a \code{\link{pkm}} model object
}
\examples{
  data(wind_RP)
  mod <- pkm(formula_p = p ~ 1, formula_k = k ~ Season, data = wind_RP$SE)
  rpk(n = 10, model = mod)

}
