% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_functions.R
\name{estgGeneric}
\alias{estgGeneric}
\title{Estimate generic g}
\usage{
estgGeneric(days, model_SE, model_CP, nsim = 1000, seed_SE = NULL,
  seed_CP = NULL)
}
\arguments{
\item{days}{Search schedule data as a vector of days searched}

\item{model_SE}{Searcher Efficiency model (\code{pkm} object)}

\item{model_CP}{Carcass Persistence model (\code{cpm} object)}

\item{nsim}{the number of simulation draws}

\item{seed_SE}{seed for random draws of the SE model}

\item{seed_CP}{seed for random draws of the CP model}
}
\value{
\code{gGeneric} object that is a list of [1] a list of g estimates,
   with one element in the list corresponding to each of the cells from the
   cross-model combination and [2] a table of predictors and cell names 
   associated with the gs
}
\description{
Generic g estimation by simulation from given SE model and CP 
  models under a specific search schedule.

The g estimated by \code{estgGeneric} is a generic aggregate detection 
  probability and represents the probability of detecting a carcass that 
  arrives at a (uniform) random time during the period monitored, for each
  of the possible cell combinations, given the SE and CP models. This 
  is somethat different from the GenEst estimation of g when the purpose 
  is to estimate total mortality (M), in which case the detection 
  probability varies with carcass arrival interval and is difficult to 
  summarize statistically. The \code{estgGeneric} estimate is a useful 
  "big picture" summary of detection probability, but would be difficult
  to work with for estimating M with precision.
}
\examples{
  data(mock)
  model_SE <- pkm(formula_p = p ~ HabitatType, formula_k = k ~ 1,
                data = mock$SE)
  model_CP <- cpm(formula_l = l ~ Visibility, formula_s = s ~ Visibility, 
                data = mock$CP, left = "LastPresentDecimalDays", 
                right = "FirstAbsentDecimalDays")
  avgSS <- averageSS(mock$SS)
  ghatsGeneric <- estgGeneric(days = avgSS, model_SE = model_SE,
   model_CP = model_CP)

}
