% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.R
\name{chat}
\alias{chat}
\title{Initiate a conversation with a Generative AI model using a prompt}
\usage{
chat(model.parameter, temperature, history, prompt)
}
\arguments{
\item{model.parameter}{A character vector containing information about the Generative AI service provider,
corresponding model, version, API key, and proxy status.}

\item{temperature}{A numeric value. Higher values yield more creative responses,
while lower values result in more straightforward text.}

\item{history}{A list containing all messages exchanged between the user and the model in a chat session.}

\item{prompt}{A character string representing the query for text generation.}
}
\value{
If successful, the full chat history, including the most recent response, will be returned. If
the API response indicates an error, the function halts execution and provides an error message.
}
\description{
This function establishes a connection to a Generative AI model by providing essential
parameters. It generates a chat response based on the provided prompt and stores it in the
history list.
}
\details{
Providing accurate and valid information for each parameter is crucial for successful
text generation by the Generative AI model. This function modifies the chat history. If any
parameter is incorrect, the function responds with an error message based on the API feedback.
To view all supported Generative AI models, use the function \code{available.models}.
Additionally, utilize \code{chat.setup} to set up a chat history. To retrieve the most recent
response generated by the model, use the function \code{chat.recent}.
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 # Setup an empty chat history
 google.history = chat.setup(google.model)
 openai.history = chat.setup(openai.model)

 # Start chat
 temperature = 0.9
 prompt = "Write a story about a magic backpack in about 100 words."
 google.history = chat(google.model,
                       temperature,
                       google.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(google.model, google.history))

 openai.history = chat(openai.model,
                       temperature,
                       openai.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(openai.model, openai.history))

 prompt = "What is the word count of the story you just wrote?"
 google.history = chat(google.model,
                       temperature,
                       google.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(google.model, google.history))

 openai.history = chat(openai.model,
                       temperature,
                       openai.history,
                       prompt)

 # Get the most recent message generated by the model
 cat(chat.recent(openai.model, openai.history))
}

}
