\name{export.impute}
\alias{export.impute}
\title{function to export GenABEL data in IMPUTE format}
\description{
	Exports GenABEL data to IMPUTE/SNPTEST/GTOOLS format
}
\usage{
	export.impute(data,genofile="impute.gen",samplefile="impute.sample",
		strandfile="impute.strand",cachesizeMb=128)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{gwaa.data object}
  \item{genofile}{Output genotype data file name}
  \item{samplefile}{Output sample information file name, 'id' header line + IDs of people will be written there}
  \item{strandfile}{name for strand output file}
  \item{cachesizeMb}{approximate amount of RAM to be used to generate chunks of data}
}
\details{
The most interesting part is the genotype file which is generated, this 
file contains one SNP per row, with columns

SNP_name_1 SNP_name_2 Position Allele1 Allele2 P_1_11 P_1_12 P_1_22 P_2_11 P_2_12 P_2_22 ...

where SNP_name_1 = SNP_name_2 is SNP name, Position is SNP position, 
Allele1 and Allele2 are reference and effective alleles; P_i_jk is the 
probability that person i has genotype jk; these are (1 0 0) for 
genotype Allele1Allele1, (0 1 0) for genotype Allele1Allele2, 
(0 0 1) for genotype Allele2Allele2, and (0 0 0) if genotype is missing
  
Strand file contains the SNP name, position and strand, as generated by 
\code{as.character(data@gtdata@strand)}; this is up to user if this 
slot contains correct data (see eg \link{convert.snp.illumina} on how 
to import strand info)
}
\value{
	No value returned; all infor stored in files
}
%\references{}
\author{Yurii Aulchenko}
%\note{}
\seealso{
	\code{\link{export.merlin}}.
}
\examples{
\dontrun{
require(GenABEL.data)
data(srdta)
export.impute(srdta[1:50,1:3])
}
}
\keyword{IO}% at least one, from doc/KEYWORDS
\keyword{manip}% at least one, from doc/KEYWORDS
