% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynlib.R
\docType{data}
\name{BaFe2As2}
\alias{BaFe2As2}
\title{Barium-Ferrum-Arsenide powder diffraction data}
\format{A \code{data.frame} with 1151 cases and 2 variables:
\describe{
  \item{angle}{ the dispersion angle, viewed as the independent variable.}
  \item{intensity}{ the neutron diffraction intensity, viewed as the response variable.}
}}
\source{
\href{http://openaccess.city.ac.uk/12418/}{openaccess.city.ac.uk}
}
\usage{
data(BaFe2As2)
}
\description{
This dataset contains the results of a neutron diffraction experiment
on Barium-Ferrum-Arsenide (\eqn{\mathrm{Ba Fe_2 As_2}})  powder carried out by
Kimber et al. (2009) and used in Kaishev et al. (2016).
The neutron diffraction intensity was measured at 1151 different dispersion angles
in order to model the diffraction profile.
}
\examples{
\dontrun{
# to load the data
data('BaFe2As2')

# fit a GeDS regression and produce a simple plot of the result. See ?NGeDS
# c.f. Kaishev et al. (2016), section 4.2
(Gmod <- NGeDS(intensity ~ f(angle), data = BaFe2As2, beta = 0.6, phi = 0.99,
               q = 3, show.iters = T))
plot(Gmod)
}

}
\references{
Kaishev, V.K., Dimitrova, D.S., Haberman, S. and Verrall, R.J. (2016).
Geometrically designed, variable knot regression splines.
\emph{Computational Statistics}, \strong{31}, 1079--1105. \cr
DOI: \href{https://doi.org/10.1007/s00180-015-0621-7}{doi.org/10.1007/s00180-015-0621-7}

Kimber, S.A.J., Kreyssig, A., Zhang, Y.Z., Jeschke, H.O., Valenti, R., Yokaichiya, F.,
 Colombier, E., Yan, J., Hansen, T.C., Chatterji, T.,
 McQueeney, R.J., Canfield, P.C., Goldman, A.I. and Argyriou, D.N. (2009).
 Similarities between structural distortions under pressure and chemical doping in superconducting
 \eqn{\mathrm{Ba Fe_2 As_2}}.
 \emph{Nat Mater}, \strong{8}, 471--475.
}

