% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gbuffer.R
\name{Gbuffer}
\alias{Gbuffer}
\title{@title Geodesic buffer around points (long, lat) using metric radius
 EXTRACTED FROM GEOBUFFER R PACKAGE}
\usage{
Gbuffer(
  xy,
  dist_m,
  step_dg = 10,
  crs = "+proj=longlat +ellps=WGS84 +datum=WGS84",
  output = "sp",
  ...
)
}
\arguments{
\item{xy}{One of the following: `SpatialPoints`, `SpatialPointsDataFrame`,
points as `sf`, or two columns `matrix`, `data.frame` or `data.table`, with
the first column containing unprojected longitudes and the second
containing unprojected latitudes of your points around which you desire
buffers.}

\item{dist_m}{Distance in meters passed as `d` to `geosphere::destPoint()`.
The distance must be a numeric vector. Its length must be either 1
(assuming you want the same buffer radius for all points in `xy`), or the
total number of points you have in `xy` (assuming you want a different
buffer radius for each point).}

\item{step_dg}{Step of bearings (directions) in degrees. Must be numeric of
length 1. Defaults to 10. Dictates the point density of the buffer edge,
therefore the buffer's shape. For example, the maximum allowed value of 120
corresponds to 360/120 = 3 points on a circle, which will form a buffer as
an equilateral triangle. For more circle-like shaped buffers, use a smaller
step like 10, 5 dg or even smaller. However, the smaller the step, the more
computational intensive the operations are. The smallest allowed value is 1
dg.}

\item{crs}{Character string of projection arguments. Defaults to
`"+proj=longlat +ellps=WGS84 +datum=WGS84"`. The CRS must be the one
corresponding to your points/coordinates. If you are unsure, then could be
a safe bet to try the default value. For more details see `?sp::CRS`.}

\item{output}{Dictates the type of output. Character vector with one of the
following values: `"sp"`, `"sf"`, `"data.table"` or `"data.frame"`.
Defaults to `"sp"`. If indicates a spatial object (`"sp"` or `"sf"`), then
it returns the buffers as polygons around the given points. If indicates a
table object (`"data.table"` or `"data.frame"`), then it returns the points
that constitute the buffers as a 3 columns `data.table` or `data.frame`:
`lon`, `lat`, `id`, where `id` is the id of each point in `xy`. This can be
useful for plotting with `ggplot2`.}

\item{...}{Additional arguments passed to `geosphere::destPoint()`, like `a`
and `f`.}
}
\value{
Depending on the value given to `output` (see above).
}
\description{
Allows the possibility of creating geodesic buffers when the
  radius is given in metric units. A geodesic buffer is not affected by the
  distortions introduced by projected coordinate systems. This function is a
  wrapper of `geosphere::destPoint()`.
}
\examples{
bucharest_500km <- Gbuffer(xy = data.frame(lon = 26.101390,
                                                 lat = 44.427764),
                                 dist_m = 500*10^3,
                                 output = "sp")
}
\references{
This function is a wrapper of `geosphere::destPoint()`. See also
  [Euclidean and Geodesic Buffering in R](https://gis.stackexchange.com/questions/250389/euclidean-and-geodesic-buffering-in-r)
  on gis.stackexchange. Also check [Understanding Geodesic Buffering](https://www.esri.com/news/arcuser/0111/geodesic.html).
}
\author{
Valentin Stefan
}
\keyword{internal}
