lme.batch.imputed <- function(phenfile,genfile,pedfile,phen,kinmat,covars=NULL,outfile){
###########################################################
  #check the existence of kinship matrix
  trykin<-try(load(kinmat))
  if (inherits(trykin,"try-error"))
        stop(paste('kinship matrix does not exist at ',kinmat))

  cor.snp <- function(y,x){  
   if(!is.numeric(y))y<-as.numeric(as.factor(y)) 
   return(sd(y)==0 || abs(cor(y,x,use="complete"))>0.99999999 )} 

  read.in.data <- function(phenfile,genfile,pedfile) {
  print("Reading in Data")
  ped.dat <- read.csv(gzfile(genfile),header=TRUE,na.string="")

  snp.names <- names(ped.dat)[-1]
  pedigree <- read.csv(pedfile,header=TRUE)
  gntp.all <- merge(pedigree,ped.dat,by="id")

  #read in phenotype data
  #------------------------------------------------------
  phen.dat=read.csv(phenfile,header=TRUE)
  phen.name=colnames(phen.dat)[-1]
  n.snp=length(names(gntp.all))

  if(length(grep("^sex$",colnames(phen.dat)))==0) {
  phensnp.dat<-merge(gntp.all,phen.dat,by=c("id"))
  } else {
  ## sex is one of the columns in the phenotype file
  phensnp.dat<-merge(gntp.all,phen.dat,by=c("id","sex"))
  }
  print("Done reading in data")
  return(list(data=phensnp.dat,snps=snp.names,phen.name=phen.name))
  }

#####################main programs##########################
  assign("phen",phen,env = .GlobalEnv,inherits=T)
  phensnp.dat <- read.in.data(phenfile,genfile,pedfile)
  snplist<-phensnp.dat$snps

  if (is.null(covars)) phenlist<-phensnp.dat$phen.name else 
     if (!is.null(covars) & sum(phensnp.dat$phen.name %in% covars)==length(covars)) phenlist<-phensnp.dat$phen.name[!phensnp.dat$phen.name %in% covars] else  
        stop('some covariates are not available')

  test.dat <- phensnp.dat$data
  assign("test.dat", test.dat, env = .GlobalEnv,inherits=T)

  if (!is.null(covars) & sum(snplist %in% covars)>=1) {
     names(test.dat)[which(names(test.dat)==paste(snplist[snplist %in% covars],".x",sep=""))] <- snplist[snplist %in% covars]
     covars[covars %in% snplist] <- paste(covars[covars %in% snplist],".y",sep="")
  }
  
  idlab <- "id"
  result <- NULL
  if (is.null(covars)) test1.dat <- na.omit(test.dat[,c(phen,idlab)]) else { 
     test1.dat <- na.omit(test.dat[,c(phen,idlab,covars)])
     xcovar<-as.matrix(test1.dat[,covars])
     assign("xcovar", xcovar, env = .GlobalEnv,inherits=T) 
  } 
  id <- test1.dat[,idlab]
  n <- length(id)
  assign("test1.dat", test1.dat, env = .GlobalEnv,inherits=T)
  assign("id",id,env = .GlobalEnv,inherits=T)               

  if (is.null(covars)) v.cov <- sum(try(lmekin(test1.dat[,phen]~1,random=~1|id,varlist=kmat,na.action=na.omit))$theta) else {
     lme.cov.out<-try(lmekin(test1.dat[,phen]~xcovar,random=~1|id,varlist=kmat,na.action=na.omit))
     v.cov <- sum(lme.cov.out$theta) 
  }

  for (i in snplist) {
      assign("i",i,env = .GlobalEnv,inherits=T)
      if (is.null(covars)) test2.dat <- na.omit(test.dat[,c(i,phen,idlab)]) else { 
         test2.dat <- na.omit(test.dat[,c(i,phen,idlab,covars)])
         x.covar<-as.matrix(test2.dat[,covars])
         assign("x.covar", x.covar, env = .GlobalEnv,inherits=T)
      } 
      assign("test2.dat", test2.dat, env = .GlobalEnv,inherits=T)
       
      imaf <- mean(test2.dat[,i])/2
      count <- table(round(test2.dat[,i]))
      gntps <- names(count)
      count1 <- rep(0,3) 
      count1[as.numeric(gntps)+1] <- count
 
      if (!is.null(covars) & length(unique(test2.dat[,i]))==1) colinear <- F else
         if (!is.null(covars) & length(covars)>1 & length(unique(test2.dat[,i]))>1) colinear <- apply(x.covar,2,cor.snp,x=test2.dat[,i]) else 
            if (!is.null(covars) & length(covars)==1 & length(unique(test2.dat[,i]))>1) colinear <- cor.snp(x.covar,test2.dat[,i]) else 
               if (is.null(covars)) colinear <- F 
     
      if (sum(colinear)>0 | sort(count1)[1]+sort(count1)[2]<10 | length(unique(test2.dat[,i]))==1 | length(count)==1) result<-rbind(result,c(phen,i,n,imaf,rep(NA,4))) else {  
         if (is.null(covars)) lme.out<-try(lmekin(test2.dat[,phen]~test2.dat[,i],random=~1|id,varlist=kmat,na.action=na.omit)) else
            lme.out<-try(lmekin(test2.dat[,phen]~test2.dat[,i]+x.covar,random=~1|id,varlist=kmat,na.action=na.omit))
         chisq<-lme.out$ctable[2,1]^2/lme.out$var[2,2]
         tmp<-c(max(v.cov-sum(lme.out$theta),0)/var(test2.dat[,phen]),lme.out$ctable[2,1],sqrt(lme.out$var[2,2]),pchisq(chisq,1,lower.tail=F))  
         if (class(tmp)=="try-error") result<-rbind(result, c(phen,i,n,imaf,rep(NA,4))) else result <- rbind(result,c(phen,i,n,imaf,tmp))       
      }
  }    

  colnames(result)<-c("phen","snp","N","AF","h2q","beta","se","pval")  

  write.table(result, outfile, quote=F,row.names=F, col.names=T,sep=",",na="")

}
