% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GSOD.R
\name{get_GSOD}
\alias{get_GSOD}
\title{Download, Clean, Reformat and Generate New Variables From GSOD Weather Data}
\usage{
get_GSOD(years = NULL, station = NULL, country = NULL, path = "",
  max_missing = 5, agroclimatology = FALSE, shapefile = FALSE,
  CSV = TRUE)
}
\arguments{
\item{years}{Year(s) of weather data to download.}

\item{station}{Specify single station for which to retrieve, check and clean
weather data.}

\item{country}{Specify a country of interest for which to retrieve weather
data, full name or 3 letter ISO code work. Use
\code{\link[raster]{getData}("ISO3")} to retrieve a list of possible three
letter ISO country codes.}

\item{path}{Path entered by user indicating where to store resulting
output file. Defaults to the current working directory.}

\item{max_missing}{The maximum number of days allowed to be missing from a
station's data before it is excluded from final file output. Defaults to five
days. If a single station is specified, this option is ignored and any data
available, even an empty file,from NCDC will be returned.}

\item{agroclimatology}{Only clean data for stations between latitudes 60 and
-60 for agroclimatology work, defaults to FALSE. Set to FALSE to override and
include only stations within the confines of these latitudes.}

\item{shapefile}{If set to TRUE, create an ESRI shapefile of vector type,
points, of the data for use in a GIS. Defaults to FALSE, no shapefile
created.}

\item{CSV}{If set to TRUE, create a comma separated value (CSV) file of data,
defaults to TRUE, a CSV file is created.}
}
\description{
This function automates downloading, cleaning, reformatting of data from
the Global Surface Summary of the Day (GSOD) data provided by the US National
Climatic Data Center (NCDC),
\url{https://data.noaa.gov/dataset/global-surface-summary-of-the-day-gsod},
and calculates three new variables; Saturation Vapor Pressure (ES) – Actual
Vapor Pressure (EA) and relative humidity (RH). Stations are individually
checked for number of missing days to assure data quality, stations with too
many missing observations are omitted, stations with a latitude of < -90 or >
90 or longitude of < -180 or > 180 are removed. All units are converted to
International System of Units (SI), e.g., Fahrenheit to Celsius and inches to
millimetres. For convenience elevation is converted from decimetres to metres.
Alternative elevation measurements are supplied for missing values or values
found to be questionable based on the Consulatative Group for International
Agricultural Research's Consortium for Spatial Information group's (CGIAR-CSI)
Shuttle Radar Topography Mission 90 metre (SRTM 90m) digital elevation data
based on NASA's original SRTM 90m data. Further information on these data and
methods can be found on GSODR's GitHub repository here:
\url{https://github.com/adamhsparks/GSODR/blob/master/data-raw/fetch_isd-history.md}
}
\details{
Due to the size of the resulting data, output is saved as a comma-separated,
csv, file (default) or ESRI shapefile in a directory specified by the user or
defaults to the current working directory. The files summarize each year by
station, which includes vapour pressure and relative humidity variables
calculated from existing data in GSOD.

All missing values in resulting files are represented as -9999
regardless of which field they occur in.

Be sure to have disk space free and allocate the proper time for this to run.
This is a time, processor and disk input/output/space intensive process.
This function was largely based on T. Hengl's "getGSOD.R" script, available
from \url{http://spatial-analyst.net/book/system/files/getGSOD.R} with
enhancements to be more cross-platform, faster and a bit more flexible.
For more information see the description of the data provided by NCDC,
\url{http://www7.ncdc.noaa.gov/CDO/GSOD_DESC.txt}.

The CSV or ESRI format shapefile in the respective year-directory
will contain the following fields/values:
\describe{
\item{STNID}{Station number (WMO/DATSAV3 number) for the location}
\item{WBAN}{Number where applicable--this is the historical "Weather Bureau
Air Force Navy" number - with WBAN being the acronym}
\item{STN.NAME}{Unique text string identifier}
\item{CTRY}{Country}
\item{LAT}{Latitude}
\item{LON}{Longitude}
\item{ELEV.M}{Station reported elevation (metres to tenths)}
\item{ELEV.M.SRTM.90m}{Corrected elevation data in whole metres for stations
derived from Jarvis et al. (2008), extracted from DEM using reported LAT/LON
values in metres}
\item{YEARMODA}{Date in YYYY-MM-DD format}
\item{YEAR}{The year}
\item{MONTH}{The month}
\item{DAY}{The day}
\item{YDAY}{Sequential day of year (not in original GSOD)}
\item{TEMP}{Mean daily temperature converted to degrees C to tenths.
Missing = -9999}
\item{TEMP.CNT}{Number of observations used in calculating mean daily
temperature}
\item{DEWP}{Mean daily dew point converted to degrees C to tenths. Missing =
-9999}
\item{DEWP.CNT}{Number of observations used in calculating mean daily
dew point}
\item{SLP}{Mean sea level pressure in millibars to tenths. Missing =
-9999}
\item{SLP.CNT}{Number of observations used in calculating mean sea level
pressure}
\item{STP}{Mean station pressure for the day in millibars to tenths
Missing = -9999}
\item{STP.CNT}{Number of observations used in calculating mean station
pressure}
\item{VISIB}{Mean visibility for the day converted to kilometers to tenths
Missing = -9999}
\item{VISIB.CNT}{Number of observations used in calculating mean daily
visibility}
\item{WDSP}{Mean daily wind speed value converted to metres/second to tenths
Missing = -9999}
\item{WDSP.CNT}{Number of observations used in calculating mean daily
windspeed}
\item{MXSPD}{Maximum sustained wind speed reported for the day converted to
metres/second to tenths. Missing = -9999}
\item{GUST}{Maximum wind gust reported for the day converted to
metres/second to tenths. Missing = -9999}
\item{MAX}{Maximum temperature reported during the day converted to Celsius
to tenths--time of maximum temperature report varies by country and region,
so this will sometimes not be the maximum for the calendar day. Missing =
-9999}
\item{MAX.FLAG}{Blank indicates maximum temperature was taken from the
explicit maximum temperature report and not from the 'hourly' data. " * "
indicates maximum temperature was derived from the hourly data (i.e., highest
hourly or synoptic-reported temperature)}
\item{MIN}{Minimum temperature reported during the day converted to Celsius
to tenths--time of minimum temperature report varies by country and region,
so this will sometimes not be the minimum for the calendar day. Missing =
-9999}
\item{MIN.FLAG}{Blank indicates minimum temperature was taken from the
explicit minimum temperature report and not from the 'hourly' data. " * "
indicates minimum temperature was derived from the hourly data (i.e., lowest
hourly or synoptic-reported temperature)}
\item{PRCP}{Total precipitation (rain and/or melted snow) reported during
the day converted to millimetres to hundredths will usually not end with the
midnight observation--i.e., may include latter part of previous day. ".00"
indicates no measurable precipitation (includes a trace). Missing = -9999.
\emph{Note}: Many stations do not report '0' on days with no precipitation--
therefore, '-9999' will often appear on these days. For example, a
station may only report a 6-hour amount for the period during which rain
fell. See PRCP.FLAG column for source of data}
\item{PRCP.FLAG}{
 \describe{
   \item{A}{= 1 report of 6-hour precipitation amount}
   \item{B}{= Summation of 2 reports of 6-hour precipitation amount}
   \item{C}{= Summation of 3 reports of 6-hour precipitation amount}
   \item{D}{= Summation of 4 reports of 6-hour precipitation amount}
   \item{E}{= 1 report of 12-hour precipitation amount}
   \item{F}{= Summation of 2 reports of 12-hour precipitation amount}
   \item{G}{= 1 report of 24-hour precipitation amount}
   \item{H}{= Station reported '0' as the amount for the day (eg, from
   6-hour reports), but also reported at least one occurrence of
   precipitation in hourly observations--this could indicate a trace
   occurred, but should be considered as incomplete data for the day}
   \item{I}{= Station did not report any precipitation data for the day and
   did not report any occurrences of precipitation in its hourly
   observations. It's still possible that precipitation occurred but was not
   reported}
   }
 }
\item{SNDP}{Snow depth in millimetres to tenths. Missing = -9999}
\item{I.FOG}{Fog, (1 = yes, 0 = no/not reported) for the occurrence during
the day}
\item{I.RAIN_DZL}{Rain or drizzle, (1 = yes, 0 = no/not reported) for the
occurrence during the day}
\item{I.SNW_ICE}{Snow or ice pellets, (1 = yes, 0 = no/not reported) for the
occurrence during the day}
\item{I.HAIL}{Hail, (1 = yes, 0 = no/not reported) for the occurrence during
the day}
\item{I.THUNDER}{Thunder, (1 = yes, 0 = no/not reported) for the occurrence
during the #' day}
\item{I.TDO_FNL}{Tornado or funnel cloud, (1 = yes, 0 = no/not reported) for
the occurrence during the day}
}

\emph{Values calculated by this package and included in final output:}
\describe{
\item{ea}{Mean daily actual vapour pressure}
\item{es}{Mean daily saturation vapour pressure}
\item{RH}{Mean daily relative humidity}
}
}
\note{
Users of these data should take into account the following (from the
NCDC website): "The following data and products may have conditions placed on
their international commercial use. They can be used within the U.S. or for
non-commercial international activities without restriction. The non-U.S.
data cannot be redistributed for commercial purposes. Re-distribution of
these data by others must provide this same notification."
}
\examples{
\dontrun{
# Download weather station for Toowoomba, Queensland for 2010, save resulting
# file in the user's "Downloads" directory.

get_GSOD(years = 2010, station = "955510-99999", path = "~/Downloads")


# Download global GSOD data for agroclimatology work for years 2009 and 2010
# and generate yearly summary files, GSOD_2009_XY and GSOD_2010_XY in folders
# named 2009 and 2010 in the user's Downloads directory with a maximum of
# five missing days per weather station allowed.

get_GSOD(years = 2010:2011, path = "~/Downloads", agroclimatology = TRUE)


# Download data for Australia for year 2010 and generate a yearly
# summary file, GSOD_2010_XY files in the user's Downloads directory with a
maximum of five missing days per station allowed.

get_GSOD(years = 2010, country = "Australia", path = "~/Downloads")
}

}
\references{
{Jarvis, A, HI Reuter, A Nelson, E Guevara, 2008, Hole-filled
SRTM for the globe Version 4, available from the CGIAR-CSI SRTM 90m Database
\url{http://srtm.csi.cgiar.org}}
}

