% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.lsn.type.matrix.R
\name{prep.lsn.type.matrix}
\alias{prep.lsn.type.matrix}
\title{Prepare Lesion Type Matrix}
\usage{
prep.lsn.type.matrix(ov.data, min.ngrp = 0)
}
\arguments{
\item{ov.data}{list of six data.frames that represent the output results of the find.gene.lsn.overlaps function.}

\item{min.ngrp}{if specified, rows with number of patients affected by all different types of lesions that's less than the specified number will be discarded (default is 0; will return all genes affected by any type of lesions in at least one patient).}
}
\value{
The function returns a lesion matrix with all types of lesions affecting certain gene as a row and each patient as a column.
}
\description{
The function prepare a lesion matrix with all types of lesions affecting certain gene as a row and each patient as a column.
}
\details{
The function returns a lesion matrix with each row as a gene and each column is a patient. If a gene is affected by one type of lesions in a certain patient, the entry will be labelled by lesion type (for example: gain OR mutation). However, if the same gene is affected by more than one type of lesions in a certain patient (for example: gain AND mutation), the entry will be labelled as "multiple". If the gene is not affected by any lesion, the entry for this patient will be labelled as "none".
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)

# prepare gene and lesion data for later computations:
prep.gene.lsn=prep.gene.lsn.data(lesion.data,
                                 hg19.gene.annotation)

# determine lesions that overlap each gene (locus):
gene.lsn.overlap=find.gene.lsn.overlaps(prep.gene.lsn)

# prepare the lesion matrix with a minimum of 5 patients affected by any type of lesion in the
# gene to be included in the final matrix
lsn.type.mtx=prep.lsn.type.matrix(gene.lsn.overlap, min.ngrp=5)
}
\references{
Pounds, Stan, et al. (2013) A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=prep.gene.lsn.data]{prep.gene.lsn.data()}}, \code{\link[=find.gene.lsn.overlaps]{find.gene.lsn.overlaps()}}
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
