% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomewide.log10q.plot.R
\name{genomewide.log10q.plot}
\alias{genomewide.log10q.plot}
\title{Genomewide log10q Plot}
\usage{
genomewide.log10q.plot(
  grin.res,
  lsn.grps,
  lsn.colors = NULL,
  max.log10q = NULL
)
}
\arguments{
\item{grin.res}{GRIN results evaluating annotated genes or lesion boundaries (output of the grin.stats function using either lesion boundaries or annotated genes as a marker input file).}

\item{lsn.grps}{Selected lesion groups to be added to the plot.}

\item{lsn.colors}{Colors assigned to each lesion group (if NULL, lesion colors will be assigned automatically using default.grin.colors function).}

\item{max.log10q}{Maximum log10 q value to be added to the plot. All boundaries or genes with -log10 q smaller than this value will be set automatically to max.log10q.}
}
\value{
The function return a genome-wide plot based on -log(10) q-value of each of the evaluated annotated genes or lesion boundaries to be affected by a certain type of lesions (gain, loss, mutation, etc...).
}
\description{
The function return a genome-wide plot based on -log(10) q-value of each of the evaluated annotated genes or lesion boundaries on each chromosome. The plot is lesion type specific (gain, loss, mutation, etc...).
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)

# This analysis is lesion type specific. So, user should first data extract data for a specific
# lesion group of interest for example gains from the lesion data file:
gain=lesion.data[lesion.data$lsn.type=="gain",]
# Return lesion boundaries for gains:
lsn.bound.gain=grin.lsn.boundaries(gain, hg19.chrom.size)
# Run GRIN analysis Using Lesion Boundaries as Markers Instead of the Gene Annotation File:
GRIN.results.gain.bound=grin.stats(gain, lsn.bound.gain, hg19.chrom.size)
# Return genomewide -log10q plot for association between lesion boundaries and gain:
genomewide.log10q.plot(GRIN.results.gain.bound, lsn.grps=c("gain"),
                       lsn.colors=c("gain" = "red"), max.log10q = 10)

# instead of lesion boundaries, users can also plot -log10q values for annotated genes using
# genes annotation data as a marker data file:
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)

genomewide.log10q.plot(grin.results, lsn.grps=c("gain"), lsn.colors=c("gain" = "red"),
                       max.log10q = 10)

# User can run this same analysis for other lesion types such as mutations and deletions.
}
\seealso{
\code{\link[=grin.lsn.boundaries]{grin.lsn.boundaries()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
