% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geno.R
\name{checkIfSampleIDsExist}
\alias{checkIfSampleIDsExist}
\title{Check if sample identifiers are stored in a BGEN file}
\usage{
checkIfSampleIDsExist(bgenFile)
}
\arguments{
\item{bgenFile}{a character of BGEN file. Sometimes, BGEN file does not include sample IDs. This information can be extracted from BGEN file. Please refer to \href{https://www.well.ox.ac.uk/~gav/bgen_format/spec/v1.2.html}{link} for more details.}
}
\value{
A logical value indicating whether sample identifiers are stored in the BGEN file. Returns \code{TRUE} if sample IDs are present, \code{FALSE} otherwise.
}
\description{
Check if sample identifiers are stored in a BGEN file, only support BGEN v1.2. Check \href{https://www.well.ox.ac.uk/~gav/bgen_format/spec/v1.2.html}{link} for more details.
}
\examples{

BGENFile <- system.file("extdata", "simuBGEN.bgen", package = "GRAB")
checkIfSampleIDsExist(BGENFile)

}
