% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/person.posterior.R
\name{trait.posterior}
\alias{trait.posterior}
\title{Calculate Posterior Estimates for Trait Parameters}
\usage{
trait.posterior(model, coefs = NULL, cores = 25, tol = 1e-04)
}
\arguments{
\item{model}{Object of class \code{GPCMlasso}.}

\item{coefs}{Vector of coefficients to be used for prediction. If \code{coefs = NULL}, 
the parameters from  the BIC-optimal model will be used. 
If cross-validation was performed, automatically the parameters from the optimal
model according to cross-validation are used.}

\item{cores}{Number of cores to be used in parallelized computation.}

\item{tol}{The maximum tolerance for numerical integration, 
for more details see \code{\link{pcubature}}.}
}
\value{
Vector containing all estimates of trait/person parameters.
}
\description{
Calculates posterior estimates for trait/person parameters using the assumption 
of Gaussian distributed parameters.
}
\examples{
data(tenseness_small)

## formula for simple model without covariates
form.0 <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~0"))

######
## fit simple RSM where loglikelihood and score function are evaluated parallel on 2 cores
rsm.0 <- GPCMlasso(form.0, tenseness_small, model = "RSM", 
control= ctrl_GPCMlasso(cores=2))
rsm.0

\dontrun{
## formula for model with covariates (and DIF detection)
form <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~."))

######
## fit GPCM model with 10 different tuning parameters
gpcm <- GPCMlasso(form, tenseness_small, model = "GPCM", 
                  control = ctrl_GPCMlasso(l.lambda = 10))
gpcm
plot(gpcm)
pred.gpcm <- predict(gpcm)
trait.gpcm <- trait.posterior(gpcm)

######
## fit RSM, detect differential step functioning (DSF)
rsm.DSF <- GPCMlasso(form, tenseness_small, model = "RSM", DSF = TRUE, 
                     control = ctrl_GPCMlasso(l.lambda = 10))
rsm.DSF
plot(rsm.DSF)

## create binary data set
tenseness_small_binary <- tenseness_small
tenseness_small_binary[,1:5][tenseness_small[,1:5]>1] <- 2

######
## fit and cross-validate Rasch model
set.seed(1860)
rm.cv <- GPCMlasso(form, tenseness_small_binary, model = "RM", cv = TRUE, 
                   control = ctrl_GPCMlasso(l.lambda = 10))
rm.cv
plot(rm.cv)
}
}
\references{
Schauberger, Gunther and Mair, Patrick (2019): A Regularization Approach for the Detection of Differential 
Item Functioning in Generalized Partial Credit Models, \emph{Behavior Research Methods}, \url{https://link.springer.com/article/10.3758/s13428-019-01224-2}
}
\seealso{
\code{\link{GPCMlasso}} \code{\link{GPCMlasso-package}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}
}
\keyword{GPCMlasso}
