% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GPCMlasso.R
\name{plot.GPCMlasso}
\alias{plot.GPCMlasso}
\title{Plot function for GPCMlasso}
\usage{
\method{plot}{GPCMlasso}(x, select = c("BIC", "AIC", "cAIC", "cv"),
log.lambda = TRUE, items_per_page = 1, items = "all", 
columns = NULL, ask_new = TRUE, lambda.lines = TRUE,
equal_range = TRUE, \dots)
}
\arguments{
\item{x}{\code{GPCMlasso} object}

\item{select}{Specifies which criterion to use for the optimal model, we recommend the 
default value "BIC". If cross-validation was performed, automatically the optimal
model according to cross-validation is used. The chosen optimal model is 
highlighted with a red dashed line.}

\item{log.lambda}{A logical value indicating whether lambda or a log-transformation of 
lambda should be used as x-axis in the plots.}

\item{items_per_page}{By default, each plot/item is put on a separate page. For example,
\code{items_per_page=4} would put four plots/items on one page.}

\item{items}{By default, all items are plotted. If \code{items=c(1,3)}, 
only the first and the third item are plotted.}

\item{columns}{Specifies the number of columns to use when several
plots are on one page. Only relevant if \code{items_per_page}>1.}

\item{ask_new}{If TRUE, the user is asked to confirm before the next item is plotted.}

\item{lambda.lines}{A logical value indicating whether a thin gray line plotted
for each value from the vector of tuning parameters from \code{object}}

\item{equal_range}{A logical value indicating whether for each plot equal limits 
on the y-axis shall be used.}

\item{...}{Further plot arguments.}
}
\description{
Plot function for a \code{GPCMlasso} object. Plots show coefficient paths
of DIF (or DSF) parameters along (a transformation of) the tuning parameter lambda.
One plot per item is created, every single parameter corresponding to this item
is depicted by a single path. 
The optimal model is highlighted with a red dashed line.
}
\examples{
data(tenseness_small)

## formula for simple model without covariates
form.0 <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~0"))

######
## fit simple RSM where loglikelihood and score function are evaluated parallel on 2 cores
rsm.0 <- GPCMlasso(form.0, tenseness_small, model = "RSM", 
control= ctrl_GPCMlasso(cores=2))
rsm.0

\dontrun{
## formula for model with covariates (and DIF detection)
form <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~."))

######
## fit GPCM model with 10 different tuning parameters
gpcm <- GPCMlasso(form, tenseness_small, model = "GPCM", 
                  control = ctrl_GPCMlasso(l.lambda = 10))
gpcm
plot(gpcm)
pred.gpcm <- predict(gpcm)
trait.gpcm <- trait.posterior(gpcm)

######
## fit RSM, detect differential step functioning (DSF)
rsm.DSF <- GPCMlasso(form, tenseness_small, model = "RSM", DSF = TRUE, 
                     control = ctrl_GPCMlasso(l.lambda = 10))
rsm.DSF
plot(rsm.DSF)

## create binary data set
tenseness_small_binary <- tenseness_small
tenseness_small_binary[,1:5][tenseness_small[,1:5]>1] <- 2

######
## fit and cross-validate Rasch model
set.seed(1860)
rm.cv <- GPCMlasso(form, tenseness_small_binary, model = "RM", cv = TRUE, 
                   control = ctrl_GPCMlasso(l.lambda = 10))
rm.cv
plot(rm.cv)
}
}
\references{
Schauberger, Gunther and Mair, Patrick (2019): A Regularization Approach for the Detection of Differential 
Item Functioning in Generalized Partial Credit Models, \emph{Behavior Research Methods}, \url{https://link.springer.com/article/10.3758/s13428-019-01224-2}
}
\seealso{
\code{\link{GPCMlasso}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}
}
