% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_weight_gp.R
\name{compute_weight_gp}
\alias{compute_weight_gp}
\title{Calculate Weights for Estimation of a Point on CERF}
\usage{
compute_weight_gp(
  w,
  w_obs,
  scaled_obs,
  hyperparam,
  inv_sigma_obs,
  GPS_m,
  kernel_fn = function(x) exp(-x^2)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{scaled_obs}{A matrix of two columns.
\itemize{
\item First column is the scaled GPS value of all samples
(GPS * 1/sqrt(alpha))
\item Second column is the scaled exposure value of all samples
(w * 1/sqrt(beta))
}}

\item{hyperparam}{A vector of hyper-parameters for the GP.
\itemize{
\item First element: alpha
\item Second element: beta
\item Third element: gamma/sigma
}}

\item{inv_sigma_obs}{Inverse of the covariance matrix between observed
samples.}

\item{GPS_m}{A data.table of GPS vectors.
\itemize{
\item Column 1: A vector of estimated GPS evaluated at the observed exposure
levels.
\item Column 2: Estimated conditional means of the exposure given covariates
for all samples (e_gps_pred).
\item Column 3: Estimated conditional standard deviation of the exposure given
covariates for all samples (e_gps_std).
}}

\item{kernel_fn}{The covariance function of GP.}
}
\value{
A vector of the weights assigned to each sample for the calculate of
posterior mean of CERF at \code{w}.
}
\description{
Calculates the weights of observed outcomes which is then used to estimate
the posterior mean of CERF at a given exposure level.
}
\examples{

set.seed(814)
#Generate synthetic data
data <- generate_synthetic_data(sample_size = 200, gps_spec = 3)
w_obs <- obs_exposure <- data$treat

# Choose an exposure level to compute CERF
w = 1.8

# Define kernel function
kernel_fn <- function(x) exp(-x^2)

# Estimate GPS function
GPS_m <- train_GPS(cov_mt = as.matrix(data[,-(1:2)]),
                   w_all = as.matrix(data$treat))

GPS <- GPS_m$GPS

# set hyperparameters
hyperparam <- c(0.1, 0.4, 1)
alpha <- hyperparam[1]
beta <- hyperparam[2]
g_sigma <- hyperparam[3]

# Compute scaled observation data and inverse of covariate matrix.
scaled_obs <- cbind(obs_exposure*sqrt(1/alpha), GPS*sqrt(1/beta))
sigma_obs <- g_sigma*kernel_fn(as.matrix(dist(scaled_obs))) + diag(nrow(scaled_obs))
inv_sigma_obs <- compute_inverse(sigma_obs)


weight <- compute_weight_gp(w = w,
                            w_obs = w_obs,
                            scaled_obs = scaled_obs,
                            hyperparam = hyperparam,
                            inv_sigma_obs = inv_sigma_obs,
                            GPS_m = GPS_m,
                            kernel_fn = kernel_fn)


}
