% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GOCore.R
\name{GOCircle}
\alias{GOCircle}
\title{Circular visualization of the results of a functional analysis.}
\usage{
GOCircle(data, title, nsub, rad1, rad2, table.legend = T, zsc.col, lfc.col,
  label.size, label.fontface)
}
\arguments{
\item{data}{A special data frame which should be the result of
\code{circle_dat}}

\item{title}{The title of the plot}

\item{nsub}{A numeric or character vector. If it's numeric then the number
defines how many processes are displayed (starting from the first row of
\code{data}). If it's a character string of processes then these processes
are displayed}

\item{rad1}{The radius of the inner circle (default=2)}

\item{rad2}{The radius of the outer circle (default=3)}

\item{table.legend}{Shall a table be displayd or not? (default=TRUE)}

\item{zsc.col}{Character vector to define the color scale for the z-score of
the form c(high, midpoint,low)}

\item{lfc.col}{A character vector specifying the color for up- and
down-regulated genes}

\item{label.size}{Size of the segment labels (default=5)}

\item{label.fontface}{Font style of the segment labels (default='bold')}
}
\description{
The circular plot combines gene expression and gene- annotation
  enrichment data. A subset of terms is displayed like the \code{GOBar} plot
  in combination with a scatterplot of the gene expression data. The whole
  plot is drawn on a specific coordinate system to achieve the circular
  layout.The segments are labeled with the term ID.
}
\details{


The outer circle shows a scatter plot for each term of the logFC of
  the assigned genes. The colors can be changed with the argument
  \code{lfc.col}.

  The \code{nsub} argument needs a bit more explanation to be used wisely. First of
  all, it can be a numeric or a character vector. If it is a character vector
  then it contains the IDs or term descriptions of the displayed processes.If
  \code{nsub} is a numeric vector then the number defines how many terms are
  displayed. It starts with the first row of the input data frame.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Building the circ object
circ<-circular_dat(EC$david, EC$genelist)

#Creating the circular plot
GOCircle(circ)

#Creating the circular plot with a different color scale
GOCircle(circ,zsc.col=c('yellow','black','cyan'))

#Creating the circular plot with different font style
GOCircle(circ,label.size=5,label.fontface='italic')
}
}
\seealso{
\code{\link{circle_dat}}, \code{\link{GOBar}}
}

