% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GOCore.R
\name{GOBubble}
\alias{GOBubble}
\title{Bubble plot.}
\usage{
GOBubble(data, display, title, color, labels, ID = T, table.legend = T,
  table.col = T, bg = T)
}
\arguments{
\item{data}{A data frame with coloumns for category, GO ID, term, adjusted
p-value, z-score, count(num of genes)}

\item{display}{A character vector. Indicates whether it should be a single
plot ('single') or a facet plot with panels for each category
(default='single')}

\item{title}{The title (on top) of the plot}

\item{color}{A character vector which defines the color of the bubbles for
each category}

\item{labels}{Sets a threshold for the displayed labels. The threshold refers
to the -log(adjusted p-value) (default=5)}

\item{ID}{If TRUE then labels are IDs else terms}

\item{table.legend}{Defines whether a table of GO ID and GO term should be
displayed on the right side of the plot or not (default=TRUE)}

\item{table.col}{If TRUE then the table entries are colored according to
their category, if FALSE then entries are black}

\item{bg}{If TRUE within the plot a grey background will be drawn}
}
\description{
The function creates a bubble plot of the input \code{data}. The
  input \code{data} can be created with the help of the
  \code{\link{circle_dat}} function.
}
\details{


The x- axis of the plot represents the z-score. The negative
  logarithm of the adjusted p-value (corresponding to the significance of the
  term) is displayed on the y-axis. The area of the plotted circles is
  proportional to the number of genes assigned to the term. Each circle is
  colored according to its category and labeled alternatively with the ID or
  term name.
}
\examples{
\dontrun{
#Load the included dataset
data(EC)

#Building the circ object
circ<-circular_dat(EC$david, EC$genelist)

#Creating the bubble plot coloring the table entries according to the category
GOBubble(circ, table.col=T)

#Creating the bubble plot displaying the term instead of the ID and without the table
GOBubble(circ,ID=F,table.legend=F)

#Faceting the plot
GOBubble(circ, display='multiple')
}
}

