% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.calculator.r
\name{interim.calculator}
\alias{interim.calculator}
\title{interim.calculator}
\usage{
interim.calculator(
  a.trt = 1,
  b.trt = 1,
  Delta.lrv = 0.3,
  Delta.tv = 0.45,
  tau.tv = 0.1,
  tau.lrv = 0.8,
  tau.ng = 0.65,
  interim.n.t = 15,
  final.n.t = 100,
  p.success = 0.4,
  responses = 10,
  x_ng = NULL,
  x_go = NULL,
  go.thresh = 0.8,
  ng.thresh = 0.8
)
}
\arguments{
\item{a.trt}{alpha parameter}

\item{b.trt}{beta parameter}

\item{Delta.lrv}{TPP info}

\item{Delta.tv}{TPP info}

\item{tau.tv}{thresholds}

\item{tau.lrv}{info}

\item{tau.ng}{info}

\item{interim.n.t}{interim sample size}

\item{final.n.t}{final sample size}

\item{p.success}{probability of success}

\item{responses}{number of responders}

\item{x_ng}{number needed for no-go}

\item{x_go}{number needed for go}

\item{go.thresh}{go threshold}

\item{ng.thresh}{no-go threshold}
}
\value{
a data.frame is returned
}
\description{
interim.calculator
}
\examples{
interim.calculator(a.trt = 1, b.trt = 1,Delta.lrv = .3, Delta.tv = .45,tau.tv = 0.10,
tau.lrv = .80, tau.ng = .65,interim.n.t = 15,final.n.t = 100, p.success = .4,
responses=10,x_ng = NULL, x_go=NULL,go.thresh=0.8, ng.thresh=0.8)
}
