% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ts.ng.ssize.oc.df.r
\name{get.ts.ng.ssize.oc.df}
\alias{get.ts.ng.ssize.oc.df}
\title{Get two sample normal-gamma sample size OC data.frame}
\usage{
get.ts.ng.ssize.oc.df(
  mu.0.c = 0,
  n.0.c = 1e-04,
  alpha.0.c = 0.25,
  beta.0.c = 1,
  s.c = 4,
  group.c = "Control",
  mu.0.t = 0,
  n.0.t = 1e-04,
  alpha.0.t = 0.25,
  beta.0.t = 1,
  s.t = 4,
  group.t = "Treatment",
  ARatio = 1,
  SS.OC.N.LB = 20,
  SS.OC.N.UB = 200,
  Delta.tv = 1.5,
  Delta.lrv = 1,
  Delta.user = 1.4,
  tau.tv = 0,
  tau.lrv = 0.8,
  tau.ng = 0.75,
  npoints = 1,
  n.MC = 500,
  seed = 1234,
  goparallel = FALSE,
  cl = cl
)
}
\arguments{
\item{mu.0.c}{prior mean for control group}

\item{n.0.c}{prior effective sample size for control group}

\item{alpha.0.c}{prior alpha parameter for control group}

\item{beta.0.c}{prior beta parameter for control group}

\item{s.c}{sample sd for control group}

\item{group.c}{group label for control group}

\item{mu.0.t}{prior mean for treatment group}

\item{n.0.t}{prior effective sample size for treatment group}

\item{alpha.0.t}{prior alpha parameter for treatment group}

\item{beta.0.t}{prior beta parameter for treatment group}

\item{s.t}{sample sd for treatment group}

\item{group.t}{group label for treatment group}

\item{ARatio}{randomization ratio}

\item{SS.OC.N.LB}{lower bound for OC curve}

\item{SS.OC.N.UB}{Upper bound for OC Curve}

\item{Delta.tv}{Base TPP}

\item{Delta.lrv}{Min TPP}

\item{Delta.user}{User's delta}

\item{tau.tv}{threshold associated with Base TPP}

\item{tau.lrv}{threshold associated with Min TPP}

\item{tau.ng}{threshold associated with No-Go}

\item{npoints}{number of points}

\item{n.MC}{n for MC sampling}

\item{seed}{random seed}

\item{goparallel}{logical to use parallel programming}

\item{cl}{cluster}

\item{N}{Total sample size}
}
\value{
A data.frame is returned
}
\description{
Get two sample normal-gamma sample size OC data.frame
}
\examples{
\donttest{
my.ts.ng.ssize.oc.df <- get.ts.ng.ssize.oc.df()
my.ts.ng.ssize.oc.df
}
}
