% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRT_models.R
\name{probs.GGUM}
\alias{probs.GGUM}
\title{Compute model probabilities for the GGUM}
\usage{
probs.GGUM(alpha, delta, taus, theta, C)
}
\arguments{
\item{alpha}{A vector of length \eqn{I} with the discrimination parameters.}

\item{delta}{A vector of length \eqn{I} with the difficulty parameters.}

\item{taus}{An \eqn{I\times M}{IxM} matrix with the threshold parameters 
(\eqn{M = 2\times\max{C}+1}{M = 2*max(C)+1}).}

\item{theta}{A vector of length \eqn{N} with the person parameters.}

\item{C}{\eqn{C} is the number of observable response categories minus 1
(i.e., the item scores will be in the set \eqn{\{0, 1, ..., C\}}). It
should either be a vector of \eqn{I} elements or a scalar. In the latter
case, it is assumed that \eqn{C} applies to all items.}
}
\value{
The function returns an \eqn{N\times I\times K}{NxIxK} array with the
  GGUM probabilities, with \eqn{K=\max{C}+1}{K=max(C)+1}. To retrieve the
  GUM-based probabilities just constrain alpha to a unit vector of length {I}
  (i.e., \code{alpha = rep(1, I)}). In this case, make sure \code{C} is
  constant across items.
}
\description{
\code{probs.GGUM} computes model probabilities for the GGUM (and
  the GUM) for given item and person parameters.
}
\section{Details}{
 This function computes the GGUM-based probabilities for all
  (person, item, response category) combinations. For the GGUM formula see
  the help for function \code{GGUM} (\code{\link[GGUM]{GGUM}}).
}

\examples{
C <- c(3, 3, 3, 5, 5)
gen <- GenData.GGUM(10, 5, C, seed = 456)
gen.alpha <- gen$alpha.gen
gen.delta <- gen$delta.gen
gen.taus  <- gen$taus.gen
gen.theta <- gen$theta.gen
 
# Compute model probabilities for the parameters above:
Ps <- probs.GGUM(gen.alpha, gen.delta, gen.taus, gen.theta, C)
Ps
# In particular, the sum of the probabilities across all response options 
# (i.e., the third dimension) should be 1 for all (person, item) combinations:
apply(Ps, 1:2, sum)
}
\author{
Jorge N. Tendeiro, \email{j.n.tendeiro@rug.nl}
}
