\name{g.analyse}
\alias{g.analyse}
\title{
function to analsyse meta-data generated by \link{g.getmeta} and \link{g.impute}
}
\description{
Analyses the output from other functions within the packages to generate a basic
descriptive summary for each accelerometer data file. Analyses include: Average 
acceleration per day, per measurement, L5M5 analyses (assessment of the five
hours with lowest acceleration and with highest acceleration). Further, the 
traditionally popular variable MVPA is automatically extracted in six variants:
without bout criteria in combination with epoch = epoch length as defined in
g.getmeta (first value of the input argument windowsizes), 1 minute,
and 5 minutes, and for bout durations 1 minute, 5 minutes or 10 minutes in
combination with the epoch length as defined in g.getmeta.

}
\usage{
g.analyse(I, C, M, IMP, qlevels = c(), qwindow = c(0, 24), quantiletype = 7,
L5M5window = c(0, 24), M5L5res = 10, includedaycrit = 16, ilevels = c(),
winhr = 5, idloc = 1,snloc=1,mvpathreshold = c(),boutcriter=c(),mvpadur=c(1,5,10),
selectdaysfile=c(),window.summary.size=10,dayborder=0,mvpa.2014 = FALSE,
closedbout=FALSE)
}

\arguments{
  \item{I}{
    the output from function \link{g.inspectfile}
  }
  \item{C}{
    the output from function \link{g.calibrate}
  }
  \item{M}{
    the output from function \link{g.getmeta}
}
  \item{IMP}{
    the output from function \link{g.impute}
}
  \item{qlevels}{
    array of percentiles for which value needs to be extracted. These need to
    be expressed as a fraction of 1, e.g. c(0.1, 0.5, 0.75). There is no limit
    to the number of percentiles. If left empty then percentiles will not be 
    extracted. Distribution will be derived from short epoch metric data, see
    \link{g.getmeta}.
  }
  \item{qwindow}{
  start and end time, in 24 hour clock hours, over which distribution in metric 
  values need to be extracted. Default value = c(0,24) will consider all 24 hours.
  }
  \item{quantiletype}{
  type of quantile function to use (default recommended). For details, see 
  quantile function in STATS package
  }
  \item{L5M5window}{
    start and end time, in 24 hour clock hours, over which L5M5 needs to be
    calculated.
  }
  \item{M5L5res}{
resoltion of L5 and M5 analysis in minutes (default: 10 minutes)
  }
  \item{includedaycrit}{
    minimum required number of valid hours in day specific analysis
    (NOTE: there is no minimum required number of hours per day in the summary
    of an entire measurement, every available hour is used to make the best possible
    inference on average metric value per average day)
  }
  \item{ilevels}{
    Levels for acceleration value frequency distribution in mg, e.g. c(0,100,200)
    There is no constriction to the number of levels.
  }
  \item{winhr}{
    window size in hours of L5 and M5 analysis (dedault = 5 hours)
  }
  \item{idloc}{
    If value = 1 (default) the code assumes that ID number is stored in the
    obvious header field. If value = 2 the code uses the character string preceding
    the character '_' in the filename as the ID number
  }
  \item{snloc}{
    If value = 1 (default) the code assumes that device serial number is stored in
    the obvious header field. If value = 2 the code uses the character string between
    the first and second character '_' in the filename as the serial number
  }
  \item{mvpathreshold}{
    Threshold for MVPA estimation. This can be a single number or an array of numbers,
    e.g. c(100,120). In the later case the code will estimate MVPA seperately for
    each threshold. If this variable is left blank c() then MVPA is not estimated
  }
    \item{boutcriter}{
    The variable boutcriter is a number between 0 and 1 and defines what fraction
    of a bout needs to be above the mvpathreshold
  }
  \item{mvpadur}{
    default = c(1,5,10). Three bout duration for which MVPA will be calculated
  }
  \item{selectdaysfile}{
  Functionality designed for the London Centre of Longidutinal studies.
  Csv file holding the relation between device serial numbers and measurement days of interest.
  }
    \item{dayborder}{
  Hour at which days start and end (default = 0), value = 4 would mean 4am
  }
  \item{window.summary.size}{
    Functionality designed for the London Centre of Longidutinal studies.
  Size in minutes of the summary window
  }
  \item{mvpa.2014}{
  If TRUE use the MVPA bout definition as has been available since 2014.
  The algorithm looks for 10 minute windows in which more than 80 percent
  of the epochs are above mvpathreshold, and then counts the entire window as mvpa.
  The new bout definition (mvpa.2014 = FALSE) looks for a group or groups
  of epochs with a value above mvpathreshold that span a time window of at
  least mvpadur minutes in  which more than boutcriter percent of the epochs are above
  the threshold.
  The motivation for the old defition was: A person who spends 10 minutes in MVPA
  with a 2 minute break in the middle is equally active as a person who spends
  8 minutes in MVPA without taking a break. Therefore, both should be counted equal
  and counted as 10 minute MVPA bout. The motivation for the new definition 
  is: not counting breaks towards MVPA simplifies interpretation and still 
  counts the two persons in the example as each others equal.
  }
  \item{closedbout}{
  If TRUE then count breaks in a bout towards the bout duration. If FALSE then only count
  time spent above the threshold towards the bout duration.
  }

}
\value{
\item{\code{summary}}{summary for the file that was analysed (see details)}
\item{\code{daysummary}}{summary per day for the file that was analysed (see details)}
}

\details{
The value \code{summary} is a dataframe and comes with the following variables:\cr
\itemize{
\item \code{ID} Participant id extracted from file header
\item \code{device_sn} Device serial number extracted from file header
\item \code{dodylocation} Body location extracted from file header
\item \code{filename} Name of the accelerometer file
\item \code{start_time} Timestamp when experiment started
\item \code{startday} Name of day when experiment started
\item \code{samplefreq}Sample frequency (Hz)
\item \code{device} Name of the device brand, e.g. Geneactiv
\item \code{clipping_score} Fraction of 15 minute windows per file for which the
acceleration in one of the three axis was close to the maximum for at least 80
percent of the time. This should be 0
\item \code{meas_dur_dys} Measurement duration (days)
\item \code{complete_24hrcycle} Fraction of 15 minute windows per 24 hours for which
valid data is available at any day of the measurement
\item \code{meas_dur_def_proto_day} Measurement duration
(days) minus the hours that are ignored at the beginning and end of the measurement
motived by protocol design
\item \code{wear_dur_def_proto_day} Measurement duration according 
to protocol (days) minus invalid time periods
\item \code{calib_err} Estimated based on all non-movement periods in the measurement
after applying the autocalibration
\item \code{calib_status} Summary statement about the status of the calibration
error minimisation
\item \code{ENMO} ENMO is the main summary measure of acceleration. The value 
presented is the average ENMO over all the available data normalised per 24 hour
cycles, with invalid data imputed by the average at similar timepoints on different
days of the week. In addition to ENMO it is possible to extract other acceleration 
metrics (i.e. BFEN, HFEN, HFENplus)
\item \code{pX_ENMO_mg_0-24h} This variable represents the Xth 
percentile in the distribution of short epoch acceleration values of the average 
day within the time interval as specified. 
\item \code{L5hr_ENMO_mg_0-24} Starting time in hours of the
least active five* hours within the time interval as specified (* window size is
modifiable in g.getmeta)
\item \code{L5_ENMO_mg} Average acceleration over L5
\item \code{M5hr_ENMO_mg_0-24} Starting time in hours of the most active
five* hours in the day within the time interval as specified (* window size is
modifiable in g.getmeta)
\item \code{M5_ENMO_mg_0-24} Average acceleration over M5
\item \code{Accelerationa 1am-6am value of ENMO (mg)} Average acceleration between
1am and 6am
\item \code{N valid WEdays} Number of valid weekend days
\item \code{N valid WDdays} Number of valid week days
\item \code{AD_...} The
variable ... was calculated per day and then averaged over all the available days
\item \code{WE_...}
The variable ... was calculated per day and then averaged over weekend days only
\item \code{WD_...}
The variable ... was calculated per day and then averaged over week days only
\item \code{WWE_...} The variable ... was calculated
per day and then averaged over weekend days. Double weekend days are averaged
This is only relevant for experiments that last for more than seven days
\item \code{WWD_...} The variable ... was calculated per
day and then averaged over week days. Double weekend days were averaged. This is
only relevant for experiments that last for more than seven days)
\item \code{..._MVPA_E5S_B1M80_T100} MVPA calculated based on 5 second epoch setting
bout duration 1 Minute and inclusion criterion of more than 80 percent. This is
only done for metric ENMO at the moment, and only if mvpathreshold is not left blank
\item \code{..._mean_ENMO...} ENMO or other metric was first calcualte per day and
then average according to AD, WD, WWE, WWD
\item \code{data exclusion strategy} A log of the decision made when calling  g.impute:
value=1 mean ignore specific hours; value=2 mean ignore all data before the first
midnight and after the last midnight
\item \code{n hours ignored at the start of the measurement (if strategy = 1)}
A log of the decision made when calling g.impute
\item \code{n hours ignored at the end of the measurement (if strategy = 1)}
A log of the decision made when calling  g.impute
\item \code{n days of measurement after which data is ignored
(if strategy = 1)}
A log of the decision made when calling  g.impute
}

The value \code{daysummary} is a dataframe and comes with the following variables:\cr
\itemize{
\item \code{ID} Participant id extracted from file header
\item \code{filename} File name
\item \code{calender_date} Calender data
\item \code{bodylocation} Body location (if known)
\item \code{N valid hours} Number of hours with valid data
\item \code{N hours} Number of hours of measurement
\item \code{Day of the week}Day of the week
\item \code{Day of measurement} Day number relative to start of the measurement
\item \code{L5_ENMO_mg_0-24h} Magnitude of average acceleration during the least
active five hours calculated with metric ENMO. Within the time window as specified
\item \code{L5hr_ENMO_mg_0-24h} Starting hour of L5 on a scale from 0 to 24, where
 14.5 means 14:30. Within the time window as specified
\item \code{M5_ENMO_mg_0-24h} Magnitude of average acceleration during the most
active five hours calculated with metric ENMO. Within the time window as specified
\item \code{M5hr_ENMO_mg_0-24h} Starting hour of M5 on a scale from 0 to 24, where
 14.5 means 14:30. Within the time window as specified
\item \code{mean_ENMO_mg_1-6am} Mean acceleration between 1am and 6am
\item \code{mean_ENMO_mg_24hr} Mean acceleration over 24 hour period
\item \code{pX_ENMO_mg_0-24h} Percentile in the short epoch distribution with
invalid data imputed.  Within the time window as specified
\item \code{[A,B)_ENMO_mg_0-24h} Time spent in minutes between (and including)
acceleration value A in mg and (excluding) acceleration value B in mg. This is
only done for metric ENMO at the moment, and only done if ilevels is not left blank
\item \code{MVPA_E5S_B1M80_T100} MVPA calculated based on 5 second epoch setting
bout duration 1 Minute and inclusion criterion of more than 80 percent. This is
only done for metric ENMO at the moment, and only if mvpathreshold is not left blank
}
}

\examples{
data(data.getmeta)
data(data.inspectfile)
data(data.calibrate)
\dontrun{
  #inspect file:
  I = g.inspectfile(datafile)
  
  #autocalibration:
  C = g.calibrate(datafile) 
  
  #get meta-data:
  M = g.getmeta(datafile, desiredtz = "Europe/London", windowsizes = c(5, 900, 3600),
  daylimit = FALSE, offset = c(0, 0, 0), scale = c(1, 1, 1), tempoffset = c(0, 0, 0))
}


#impute meta-data:
IMP = g.impute(M = data.getmeta, I = data.inspectfile)

#analyse and produce summary:
A = g.analyse(I = data.inspectfile, C = data.calibrate, M = data.getmeta, IMP)

}
\author{
Vincent T van Hees <vincentvanhees@gmail.com>
}