% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GFD-function.R
\name{GFD}
\alias{GFD}
\title{Tests for General Factorial Designs}
\usage{
GFD(formula, data = NULL, nperm = 10000, alpha = 0.05,
  nested.levels.unique = FALSE)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains the factor
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. The default option is \code{NULL}.}

\item{nperm}{The number of permutations used for calculating the permuted 
Wald-type statistic. The default option is 10000.}

\item{alpha}{A number specifying the significance level; the default is 0.05.}

\item{nested.levels.unique}{A logical specifying whether the levels of the nested factor(s)
are labeled uniquely or not. Default is FALSE, i.e., the levels of the nested 
factor are the same for each level of the main factor.}
}
\value{
A \code{GFD} object containing the following components:
\item{Descriptive}{Some descriptive statistics of the data for all factor
  level combinations. Displayed are the number of individuals per factor
  level combination, the mean, variance and 100*(1-alpha)\% confidence
  intervals.}
 \item{WTS}{The value of the WTS along with degrees of freedom of the central chi-square distribution and p-value, as well as the p-value of the permutation procedure.}
 \item{ATS}{The value of the ATS, degrees of freedom of the central F distribution and the corresponding p-value.}
}
\description{
The GFD function calculates the Wald-type statistic (WTS), the ANOVA-type 
statistic (ATS) as well as a permutation version of the WTS for general 
factorial designs.
}
\details{
The package provides the Wald-type statistic, a permuted version
  thereof as well as the ANOVA-type statistic for general factorial designs,
  even with non-normal error terms and/or heteroscedastic variances. It is
  implemented for both crossed and hierarchically nested designs and allows
  for an arbitrary number of factor combinations as well as different sample
  sizes in the crossed design.
  The \code{GFD} function returns three p-values: One for the ATS based on an F-quantile and
  two for the WTS, one based on the \eqn{\chi^2}
   distribution and one based on the permutation procedure.
  Since the ATS is only an approximation and the WTS based on the \eqn{\chi^2}
  distribution is known 
  to be very liberal for small sample sizes, we recommend to use the WTPS in these situations.
}
\examples{
GFD(weightgain ~ source * type, data = HSAUR::weightgain, nperm = 1000)

data(startup)
model <- GFD(Costs ~ company, data = startup)
summary(model)

}
\references{
Friedrich, S., Konietschke, F., Pauly, M.(2017). GFD - An R-package
for the Analysis of General Factorial Designs. Journal of Statistical Software, Code Snippets 79(1), 1--18, doi:10.18637/jss.v079.c01.


Pauly, M., Brunner, E., Konietschke, F.(2015). Asymptotic Permutation Tests in General Factorial Designs. Journal of the Royal Statistical Society - Series B 77, 461-473.
}

