
test_that("checking GDINA extract calculation", {

  Q <- matrix(c(1,0,
                0,1,
                1,1),ncol = 2,byrow = TRUE)

  itempar <- list(c(0.1,0.9),
                  c(0.2,0.8),
                  c(0.1,0.2,0.3,0.8))

  Q <- Q[rep(1:3,3),]
  itempar <- itempar[rep(1:3,3)]

  set.seed(123)
  dat <- matrix(c(1,	0,	0,	0,	0,	0,	1,	0,	0,	10,
                  1,	0,	1,	1,	1,	1,	1,	1,	1,	20,
                  1,	0,	0,	0,	0,	0,	1,	1,	0,	10,
                  0,	1,	1,	1,	1,	1,	1,	1,	1,	20,
                  1,	1,	1,	1,	1,	1,	1,	1,	1,	60,
                  0,	0,	0,	0,	1,	0,	0,	0,	0,	30,
                  0,	1,	1,	0,	1,	1,	0,	1,	0,	20,
                  1,	1,	1,	1,	1,	0,	1,	1,	0,	10,
                  0,	1,	0,	0,	0,	0,	0,	1,	0,	10,
                  1,	1,	0,	1,	0,	0,	1,	0,	1,	10,
                  1,	0,	0,	1,	1,	1,	1,	0,	1,	10,
                  1,	1,	0,	0,	0,	1,	0,	1,	0,	10,
                  0,	1,	1,	0,	1,	0,	0,	0,	0,	10,
                  0,	1,	0,	0,	0,	0,	0,	0,	0,	50,
                  1,	1,	0,	1,	1,	1,	1,	1,	0,	10,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,	20,
                  0,	0,	0,	0,	0,	0,	1,	1,	0,	10,
                  1,	0,	0,	1,	1,	0,	0,	0,	0,	10,
                  1,	0,	0,	1,	0,	1,	1,	1,	1,	10,
                  1,	1,	0,	1,	1,	0,	1,	1,	0,	10,
                  0,	0,	1,	0,	1,	0,	0,	1,	1,	10,
                  0,	1,	1,	0,	1,	0,	0,	1,	0,	20,
                  1,	1,	1,	1,	1,	1,	1,	0,	0,	20,
                  0,	1,	0,	0,	0,	1,	0,	1,	0,	10,
                  1,	1,	1,	0,	1,	0,	0,	1,	0,	10,
                  1,	0,	0,	1,	0,	0,	1,	0,	1,	40,
                  1,	1,	1,	0,	0,	1,	1,	1,	0,	10,
                  1,	1,	1,	1,	1,	0,	1,	1,	1,	40,
                  0,	1,	0,	0,	1,	0,	0,	1,	0,	20,
                  1,	1,	0,	0,	0,	1,	0,	1,	1,	10,
                  0,	0,	0,	0,	0,	0,	0,	0,	0,	90,
                  0,	1,	0,	1,	0,	0,	1,	0,	0,	20,
                  0,	0,	0,	0,	0,	0,	1,	1,	1,	10,
                  1,	0,	1,	1,	1,	0,	1,	0,	0,	10,
                  1,	1,	0,	1,	0,	0,	1,	0,	0,	20,
                  1,	0,	0,	1,	0,	0,	1,	1,	0,	20,
                  0,	0,	0,	0,	0,	1,	0,	0,	1,	20,
                  1,	0,	0,	1,	0,	1,	1,	1,	0,	10,
                  1,	0,	0,	1,	0,	0,	1,	0,	0,	30,
                  1,	1,	1,	1,	1,	1,	0,	1,	1,	10,
                  0,	0,	0,	1,	0,	0,	1,	0,	1,	10,
                  1,	0,	0,	1,	1,	0,	1,	0,	0,	20,
                  0,	0,	1,	0,	1,	0,	0,	1,	0,	10,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,	20,
                  1,	0,	0,	1,	0,	1,	1,	0,	0,	30,
                  1,	1,	1,	1,	1,	1,	1,	1,	0,	10,
                  1,	1,	1,	1,	0,	1,	1,	1,	1,	10,
                  1,	0,	1,	1,	1,	1,	0,	1,	1,	10,
                  0,	1,	0,	0,	0,	0,	0,	1,	1,	10,
                  0,	1,	0,	0,	1,	1,	0,	1,	0,	10,
                  0,	1,	1,	1,	1,	1,	0,	1,	1,	10,
                  0,	1,	1,	1,	0,	1,	1,	1,	1,	10,
                  0,	1,	1,	1,	1,	0,	0,	1,	1,	10,
                  0,	0,	0,	0,	1,	1,	0,	1,	0,	10,
                  0,	0,	1,	1,	1,	0,	1,	0,	0,	10,
                  0,	1,	0,	1,	0,	1,	0,	0,	0,	10,
                  1,	1,	1,	1,	0,	0,	1,	1,	0,	10,
                  0,	1,	0,	0,	1,	0,	0,	1,	1,	10),ncol = 10,byrow = TRUE)

  dat <- dat[rep(1:nrow(dat),dat[,10]),1:9]
  est <- GDINA(dat,Q,catprob.parm = itempar,model = "GDINA",control=list(conv.crit = 0.0001))


  expect_equal(est$testfit$Deviance,9449.704, tolerance = .02)
  expect_equal(extract(est,"AIC"),9503.704, tolerance = .02)
  expect_equal(extract(est,"att.dist"),"saturated")
  expect_equal(extract(est,"att.prior"),c(0.2708239,0.2998923,0.1588651,0.2704186), tolerance = .02)
  expect_equal(extract(est,"att.str"),NULL)
  expect_equal(extract(est,"BIC"),9636.213, tolerance = .02)
  expect_equal(extract(est,"dif.p"),9.103323e-05, tolerance = .02)
  expect_equal(extract(est,"dif.prior"),3.174468e-05, tolerance = .02)
  expect_equal(extract(est,"dif.LL"),0.007430699, tolerance = .02)
  dis <- matrix(c(0.7405349,	0.13438509,
                  0.599942,	0.08818324,
                  0.9566728,	0.16014025,
                  0.9459908,	0.21929755,
                  0.6548613,	0.10506696,
                  0.6205445,	0.05781747,
                  0.794119,	0.15453654,
                  0.7051567,	0.12182567,
                  0.6143112,	0.06041622),ncol = 2,byrow = T)
  expect_equal(max(abs(as.matrix(extract(est,"discrim"))-dis))<0.001,TRUE)


})
