\name{NormEventCountsData}
\alias{NormEventCountsData}
\docType{data}
\title{
Normalization Factors for GDELT data, 1979-2012
}
\description{
The included datasets provide daily, monthly, and yearly global and country-specific total event counts for normalizing over time event count data, and the dataframe 'countries' provides a complete list of FIPS 10-4 country codes.
}
\usage{data(NormEventCountsData)}
\format{
  The format is:
\preformatted{List of 7
 $ countries      :'data.frame':	196 obs. of  2 variables:
  ..$ country.name: chr [1:196] "AFGHANISTAN" "ANGOLA" "ALBANIA" "ANDORRA" ...
  ..$ fips104     : chr [1:196] "AF" "AO" "AL" "AN" ...
  ..- attr(*, "na.action")=Class 'omit'  Named int [1:68] 1 4 5 11 12 13 27 30 36 40 ...
  .. .. ..- attr(*, "names")= chr [1:68] "1" "4" "5" "11" ...
 $ daily          :'data.frame':	12613 obs. of  2 variables:
  ..$ day  : int [1:12613] 19790210 19790410 19790610 19790810 19791010 19791210 19800210 19800410 19800610 19800810 ...
  ..$ total: int [1:12613] 825 1172 1148 1308 1267 1549 799 1629 1512 1747 ...
 $ daily.country  :'data.frame':	1801796 obs. of  3 variables:
  ..$ day    : int [1:1801796] 19790105 19790106 19790108 19790108 19790108 19790109 19790111 19790111 19790112 19790113 ...
  ..$ country: Factor w/ 263 levels "AA","AC","AE",..: 110 103 81 143 216 132 115 190 32 12 ...
  ..$ total  : int [1:1801796] 59 1 23 7 4 6 7 1 6 6 ...
 $ monthly        :'data.frame':	415 obs. of  2 variables:
  ..$ month: int [1:415] 198004 198204 198404 198604 198804 199004 199204 199404 199604 199804 ...
  ..$ total: int [1:415] 40402 61247 74581 96452 101710 83908 112952 128486 175319 361448 ...
 $ monthly.country:'data.frame':	90911 obs. of  3 variables:
  ..$ month  : int [1:90911] 197901 197901 197902 197903 197903 197905 197906 197907 197907 197907 ...
  ..$ country: Factor w/ 263 levels "AA","AC","AE",..: 89 164 212 131 197 114 26 7 97 170 ...
  ..$ total  : int [1:90911] 8 157 16 10 2 195 80 92 11 152 ...
 $ yearly         :'data.frame':	34 obs. of  2 variables:
  ..$ year : Factor w/ 36 levels "\\N","1979","1980",..: 23 6 16 17 20 28 32 11 13 18 ...
  ..$ total: int [1:34] 4540506 848806 1310741 1774666 3652082 3534874 23464598 1183220 1126957 1780524 ...
 $ yearly.country :'data.frame':	8490 obs. of  3 variables:
  ..$ year   : int [1:8490] 1979 1982 1984 1985 1987 1989 1990 1993 1995 1995 ...
  ..$ country: Factor w/ 263 levels "AA","AC","AE",..: 215 51 11 154 124 108 241 68 49 187 ...
  ..$ total  : int [1:8490] 601 95 3 37 2619 10228 29762 2143 458 21846 ...
  }
}
\details{
The values are the total number of records in the GDELT database for the time period or tim period and country specified
}
\source{
These datasets were coded by John Beieler from the GDELT historical backfiles.
}
\references{
  GDELT: Global Data on Events, Location and Tone,
  1979-2012. Presented at the 2013 meeting of the
  International Studies Association in San Francisco, CA.
  \url{http://gdelt.utdallas.edu/}
}
\examples{
data(NormEventCountsData)
str(NormEventCountsData)
}
\keyword{datasets}
