% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparisonSEMean.R
\name{ComparisonSEMean}
\alias{ComparisonSEMean}
\title{Comparison of the resampling approaches based on the SE/MSE for the mean.}
\usage{
ComparisonSEMean(
  generator,
  sampleSize = 10,
  numberOfSamples = 100,
  repetitions = 100,
  trueMean = NA,
  theta = 1/3,
  ...
)
}
\arguments{
\item{generator}{Name of the generator for sampling initial samples.
For the possible names check the values of \code{samplingGenerators} vector.}

\item{sampleSize}{Size of the single initial sample.}

\item{numberOfSamples}{Number of the initial samples.}

\item{repetitions}{Number of the secondary samples which are created using the selected resampling method.}

\item{trueMean}{If the value is given, then the mean-squared error (MSE) is calculated for this value and the means of the bootstrapped
samples. Otherwise, the standard error (SE) is calculated based on the overall mean of the secondary samples.}

\item{theta}{The weighting parameter for the mid/spread distance applied in the C-test.}

\item{...}{Parameters which are passed to \code{SEResamplingMean} or the respective \code{generator}}
}
\value{
This function returns a vector of the averaged SE/MSE for the mean.
}
\description{
\code{ComparisonSEMean} estimates the standard error (SE) or the mean-squared error (MSE) for the mean for
all resampling approaches.
}
\details{
The function generates a sequence of initial samples (their number is given in \code{initialSamples},
the size is determined by \code{sampleSize}) for fuzzy numbers of the type specified by \code{generator}.
Then the SE/MSE is calculated for each combination of the initial sample and
resampling method using \code{SEResamplingMean}. The output values are the SE/MSE averaged by \code{initialSamples}.
}
\examples{

\dontrun{

# seed PRNG

set.seed(1234)

# calculate the SE of the mean for the synthetic data generated using GeneratorNU function

ComparisonSEMean(generator = "GeneratorNU",sampleSize = 10,
 numberOfSamples = 100, repetitions = 10,mu = 0, sigma = 1,a = 0.5, b = 1)}


}
\references{
Bertoluzza, C., Corral, N., Salas, A. (1995)
On a new class of distances between fuzzy numbers
Mathware and Soft Computing, 2 (2), pp. 71-84

Grzegorzewski, P., Romaniuk, M. (2022)
Bootstrap methods for fuzzy data
Uncertainty and Imprecision in Decision Making and Decision Support: New Advances, Challenges, and Perspectives, pp. 28-47
Springer
}
\seealso{
\code{\link{ComparisonOneSampleCTest}} for the comparison of resampling methods based on power for the one-sample C-test
for the mean,
\code{\link{ComparePowerOneSampleCTest}} for the comparison of resampling methods based on power for the one-sample C-test
for the mean.

Other comparison of resampling methods: 
\code{\link{ComparePowerOneSampleCTest}()},
\code{\link{ComparisonOneSampleCTest}()}
}
\concept{comparison of resampling methods}
