% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAFmethod.R
\name{VAFmethod}
\alias{VAFmethod}
\title{V(alue)A(mbiguity)F(uzziness) resampling method for triangular and trapezoidal fuzzy numbers}
\usage{
VAFmethod(initialSample, b = n, increases = FALSE)
}
\arguments{
\item{initialSample}{Initial sample of triangular or trapezoidal fuzzy numbers.}

\item{b}{The number of fuzzy values in the resampled (secondary) sample.
If this parameter is not specified, the number of values in the initial sample is used.
The parameter should be integer value more than 0.}

\item{increases}{If \code{TRUE} is used, then the initial sample should consist of the fuzzy numbers in the form:
 left increment of the support, left end of the core, right end of the core,
right increment of the support. Otherwise, the default value \code{FALSE} is used and the fuzzy numbers should be given in the form:
left end of the support, left end of the core, right end of the core,
right end of the support.}
}
\value{
This function returns matrix with \code{b} rows of double values.
In each row, there is a single resampled fuzzy number.
These fuzzy numbers have the same form as the values from the initial sample depending on the provided parameter \code{increases}.
}
\description{
`VAFmethod` returns the secondary (bootstrapped) sample and uses the resampling
scheme which does not change the values, ambiguities and fuzziness of the fuzzy variables from
 the initial sample (the VAF method, see (Grzegorzewski et al, 2020)).
}
\details{
The initial sample should consist of triangular or trapezoidal fuzzy numbers, given as a single vector or a whole matrix.
In each row, there should be a single fuzzy number in one of the forms:
\enumerate{
 \item left end of the support, left end of the core, right end of the core, right end of the support, or
 \item left increment of the support, left end of the core, right end of the core, right increment of the support.
}
In this second case, the parameter \code{increases=TRUE} has to be used.

The resampling procedure produces \code{b} fuzzy values.
During the first step, the fuzzy value from the initial sample is randomly chosen (with repetition).
Then the new fuzzy variable, which preserves the value,  ambiguity and fuzziness of the old one, is randomly created.
If the parameter \code{b} is not specified, it is equal to the length of the initial sample.
The output is given in the same form as the initial sample.
}
\examples{

# prepare some fuzzy numbers (first type of the initial sample)

fuzzyValues <- matrix(c(0.25,0.5,1,1.25,0.75,1,1.5,2.2,-1,0,0,2),
ncol = 4,byrow = TRUE)

# generate the secondary sample using the VAF method

VAFmethod(fuzzyValues)

VAFmethod(fuzzyValues,b=4)

# prepare some fuzzy numbers (second type of the initial sample)

fuzzyValuesInc <- matrix(c(0.25,0.5,1,0.25,0.25,1,1.5,0.7,1,0,0,2),
ncol = 4,byrow = TRUE)

# generate the secondary sample using the VAF method

VAFmethod(fuzzyValuesInc,increases = TRUE)

VAFmethod(fuzzyValuesInc,b=4,increases = TRUE)

}
\references{
Grzegorzewski, P., Hryniewicz, O., Romaniuk, M. (2020)
Flexible resampling for fuzzy data based on the canonical representation
International Journal of Computational Intelligence Systems, 13 (1), pp. 1650-1662
}
\seealso{
@seealso \code{\link{classicalBootstrap}},
\code{\link{EWmethod}} for the EW method, \code{\link{VAFmethod}} for the VAF method,
\code{\link{VAAmethod}} for the VAA method, \code{\link{dmethod}} for the d method, \code{\link{wmethod}} for the w method

Other resampling functions: 
\code{\link{EWmethod}()},
\code{\link{VAAmethod}()},
\code{\link{VAmethod}()},
\code{\link{classicalBootstrap}()},
\code{\link{dmethod}()},
\code{\link{wmethod}()}
}
\concept{resampling functions}
