% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{addmf}
\alias{addmf}
\title{Insert a membership function.}
\usage{
addmf(fis, varType, varIndex, mfName, mfType, mfParams)
}
\arguments{
\item{fis}{A fis structure is to be provided.}

\item{varType}{Should be either 'input' or 'output', which relates to the type of variable (stored on the existing fis structure) that the membership function will be added to.}

\item{varIndex}{Should be an integer value representing the index value of the input or output variable that the membership function will be added to (base 1).}

\item{mfName}{Membership function name to be declared, for example (Poor,Good)}

\item{mfType}{Membership function type to be declared, for example (trimf, trapmf)}

\item{mfParams}{The value of membership function.}
}
\value{
A fis structure with the new membership function added.
}
\description{
Adds a membership function to a variable of a fis object.
}
\examples{
fis <- newfis('tipper')
fis <- addvar(fis, 'input', 'service', c(0, 10))
fis <- addmf(fis, 'input', 1, 'poor', 'gaussmf', c(1.5, 0))
}
