% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyMF.R
\name{evalmf}
\alias{evalmf}
\title{Evaluate fuzzy membership function}
\usage{
evalmf(...)
}
\arguments{
\item{...}{This function has accepted these arguments namely; x, mf.type, mf.params and mf. See the explanation on details section.}
}
\value{
Membership grade(s)
}
\description{
To obtain the corresponding membership grade(s) for the crsip input(s) x
}
\details{
This function involved such as these arguments:\cr

x - A generic element of U, which is the universe of discourse for a fuzzy set \cr
mf.type - The type of fuzzy membership function\cr
mf.params - The parameters for the given type of membership function\cr
mf - the membership function generated by \code{\link{genmf}}

This function can be used in two ways in order to obtain the membership grade(s) (see the examples section) : \cr\cr
1. evalmf(x, mf.type, mf.params)\cr
2. evalmf(x,mf)
}
\examples{
evalmf(5, mf.type=gbellmf, mf.params=c(1,2,3))
evalmf(1:10, mf.type=gbellmf, mf.params=c(1,2,3))

mf <- genmf(gbellmf, c(1,2,3))
evalmf(5, mf)
evalmf(1:10, mf)
}
\author{
Chao Chen
}

