% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-compare.R
\docType{methods}
\name{possibilityUndervaluation}
\alias{possibilityUndervaluation}
\alias{possibilityUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Possibility of undervaluation}
\usage{
\S4method{possibilityUndervaluation}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(e1, e2)
}
\arguments{
\item{e1}{a PiecewiseLinearFuzzyNumber}

\item{e2}{a PiecewiseLinearFuzzyNumber}
}
\value{
Returns a value from range [0,1] indicating the possibility of 
exceedance of e2 by e1.
}
\description{
Determines value of possibility of \eqn{e1<=e2}, the result is from
range [0,1]. Value 0 indicates no fulfilment of the operator
and 1 indicates complete fulfilment.

The detailed description of the operator and its definition 
is provided in article referenced below.
}
\examples{
a <- TriangularFuzzyNumber(0.2, 1.0, 2.8)
b <- TriangularFuzzyNumber(0, 1.8, 2.2)
a <- as.PiecewiseLinearFuzzyNumber(a, knot.n = 9)
b <- as.PiecewiseLinearFuzzyNumber(b, knot.n = 9)
possibilityUndervaluation(a,b)
}
\references{
DUBOIS, Didier and PRADE, Henri, 1983, Ranking Fuzzy Numbers in the Setting of Possibility Theory. Information Sciences. 1983. Vol. 30, no. 3, p. 183--224.
}
\seealso{
Other PiecewiseLinearFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{PiecewiseLinearFuzzyNumber-class}},
  \code{\link{PiecewiseLinearFuzzyNumber}},
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{alphaInterval}}, \code{\link{arctan2}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}},
  \code{\link{expectedInterval}}, \code{\link{fapply}},
  \code{\link{maximum}}, \code{\link{minimum}},
  \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{plot}}, \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}}

Other comparison-operators: \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}}
}

