% Generated by roxygen2 (4.0.1): do not edit by hand
\name{crispLP}
\alias{crispLP}
\title{Solves a crisp linear programming problem.}
\usage{
crispLP(objective, A, dir, b, maximum = TRUE, verbose = TRUE)
}
\arguments{
\item{objective}{A vector \eqn{(c_1, c_2, \ldots, c_n)}{(c1, c2, \ldots, cn)} with the objective function coefficients \eqn{f(x)=c_1 x_1+\ldots+c_n x_n}{f(x)=c1*x1+\ldots+cn*xn}.}

\item{A}{Technological matrix of Real Numbers.}

\item{dir}{Vector of strings with the direction of the inequalities, of the same length as \code{b}. Each element
of the vector must be one of "=", ">=", "<=", "<" or ">".}

\item{b}{Vector with the right hand side of the constraints.}

\item{maximum}{\code{TRUE} to maximize the objective function, \code{FALSE} to minimize the objective function.}

\item{verbose}{\code{TRUE} to show aditional screen info, \code{FALSE} to hide aditional screen info.}
}
\value{
\code{crispLP} returns the solution if the solver has found it or NULL if not.
}
\description{
\code{crispLP} use the classic solver (simplex) to solve a crisp linear programming problem:
\deqn{Max\, f(x)\ or\ Min\ f(x)}{Max f(x) or Min f(x)}
\deqn{s.t.:\quad Ax<=b}{s.t.:  Ax<=b}
}
\examples{
## maximize:   3*x1 + x2
## s.t.:       1.875*x1   - 1.5*x2 <= 4
##              4.75*x1 + 2.125*x2 <= 14.5
##               x1, x2 are non-negative real numbers

obj <- c(3, 1)
A <- matrix(c(1.875, 4.75, -1.5, 2.125), nrow = 2)
dir <- c("<=", "<=")
b <- c(4, 14.5)
max <- TRUE

crispLP(obj, A, dir, b, maximum = max, verbose = TRUE)
}

