% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GapsChangesDec.R
\name{GapChangeDec}
\alias{GapChangeDec}
\title{Forest Gaps Change Detection}
\usage{
GapChangeDec(gap_layer1,gap_layer2)
}
\arguments{
\item{gap_layer1}{ALS-derived gap as an \code{\link[raster:Raster-classes]{raster::RasterLayer}} object at time 1. (output of  \code{\link[=getForestGaps]{getForestGaps()}} function).}

\item{gap_layer2}{ALS-derived gap as an \code{\link[raster:Raster-classes]{raster::RasterLayer}} object at time 2. (output of  \code{\link[=getForestGaps]{getForestGaps()}} function).}
}
\value{
A \code{\link[raster:Raster-classes]{raster::RasterLayer}} object representing forest gap change area
}
\description{
This function detects forest canopy gap changes across two forest gap \code{\link[raster:Raster-classes]{raster::RasterLayer}} objects
}
\examples{
#
# Loading raster and viridis libraries
library(raster)
library(viridis)

# ALS-derived CHM from Fazenda Cauxi - Brazilian tropical forest
data(ALS_CHM_CAU_2012)
data(ALS_CHM_CAU_2014)

# set height thresholds (e.g. 10 meters)
threshold <- 10
size <- c(1, 10^4) # m2

# Detecting forest gaps
gaps_cau2012 <- getForestGaps(chm_layer = ALS_CHM_CAU_2012, threshold = threshold, size = size)
gaps_cau2014 <- getForestGaps(chm_layer = ALS_CHM_CAU_2014, threshold = threshold, size = size)

# Detecting forest gaps changes
Gap_changes <- GapChangeDec(gap_layer1 = gaps_cau2012, gap_layer2 = gaps_cau2014)

# Plotting ALS-derived CHM and forest gaps
oldpar <- par(mfrow = c(1, 3))
plot(ALS_CHM_CAU_2012, main = "Forest Canopy Gap - 2012", col = viridis(10))
plot(gaps_cau2012, add = TRUE, col = "red", legend = FALSE)

plot(ALS_CHM_CAU_2014, main = "Forest Canopy Gap - 2014", col = viridis(10))
plot(gaps_cau2014, add = TRUE, col = "red", legend = FALSE)

plot(ALS_CHM_CAU_2014, main = "Forest Gap Changes Detected", col = viridis(10))
plot(Gap_changes, add = TRUE, col = "orange", legend = FALSE)
par(oldpar)
}
\author{
Carlos Alberto Silva.
}
